/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.cal;

import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.fun.FunctionUtil;
import com.manatee.fun.IFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.exp.util.SpecialSymbolsUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Stack;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CalFun
implements IFunction {
    private String name = "cal";
    @Resource
    private VariableUtil variableUtil;
    static String[] CAL_FH = new String[]{"+", "-", "&", "|", "*", "/", "%"};
    String[] FH = new String[]{"(", ")", "-", "&", "|", "*", "%", "/"};

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        Object result = null;
        List parameters = content.getParameters();
        if (!FunctionUtil.checkParameter(parameters, 1)) {
            return result;
        }
        String exp = (String)parameters.get(0);
        return this.doCal((ProcessContent)content, exp);
    }

    public Object doCal(ProcessContent content, String exp) {
        String str = this.stringBuilder(content, exp = this.variableUtil.calRepVar(content, exp));
        if (StringUtil.isNotBlank((String)str)) {
            return str;
        }
        if (exp.indexOf("##") != -1) {
            exp = SpecialSymbolsUtil.specialSymbolBack(exp);
        }
        Double cal = CalFun.compute(content, exp);
        return this.formatNum(cal);
    }

    private Object formatNum(Double cal) {
        String last;
        String calStr = cal + "";
        if (calStr.length() >= 3 && ".0".equals(last = calStr.substring(calStr.length() - 2))) {
            Long longNum = Long.valueOf(calStr.substring(0, calStr.length() - 2));
            if (longNum > Integer.MAX_VALUE) {
                return longNum;
            }
            return longNum.intValue();
        }
        return cal;
    }

    public static boolean lastIsCal(String exp) {
        String funLast = exp.substring(exp.length() - 1);
        if ("(".equals(funLast)) {
            return true;
        }
        for (int i2 = 0; i2 < CAL_FH.length; ++i2) {
            String str = CAL_FH[i2];
            if (exp.indexOf(str) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isCal(String exp) {
        for (int i2 = 0; i2 < CAL_FH.length; ++i2) {
            String str = CAL_FH[i2];
            if (exp.indexOf(str) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean mayStr(String exp) {
        if (exp.indexOf("##YINHAO##") != -1 || exp.startsWith("\"") && exp.endsWith("\"")) {
            return true;
        }
        if (exp.indexOf("+") == -1) {
            return false;
        }
        for (int i2 = 0; i2 < this.FH.length; ++i2) {
            String str = this.FH[i2];
            if (exp.indexOf(str) == -1) continue;
            return false;
        }
        return true;
    }

    private String getValue(ProcessContent content, String exp) {
        Object value;
        if (StringUtil.isBlank((String)exp)) {
            return "";
        }
        if (NumberUtils.isNumeric((String)exp)) {
            return exp;
        }
        if (exp.length() > 1) {
            if (exp.indexOf("\"") != -1) {
                return exp.replace("\"", "");
            }
            if (exp.indexOf("##YINHAO##") != -1) {
                return exp.replace("##YINHAO##", "");
            }
        }
        if ((value = content.getValue(exp)) == null) {
            return "";
        }
        return value + "";
    }

    private String stringBuilder(ProcessContent content, String exp) {
        StringBuilder sb = new StringBuilder();
        if (!this.mayStr(exp)) {
            return "";
        }
        String[] exps = exp.split("\\+");
        if (exps.length == 0) {
            return "";
        }
        boolean haveStr = false;
        for (int i2 = 0; i2 < exps.length; ++i2) {
            String aExp = exps[i2].trim();
            String value = this.getValue(content, aExp);
            sb.append(value);
            if (NumberUtils.isNumeric((String)value)) continue;
            haveStr = true;
        }
        if (haveStr) {
            return sb.toString();
        }
        return "";
    }

    private static int priority(char s) {
        switch (s) {
            case '(': 
            case ')': {
                return 0;
            }
            case '&': 
            case '+': 
            case '-': 
            case '|': {
                return 1;
            }
            case '%': 
            case '*': 
            case '/': {
                return 2;
            }
        }
        return -1;
    }

    private static double compute(double num1, double num2, char s) {
        switch (s) {
            case '(': 
            case ')': {
                return 0.0;
            }
            case '-': {
                return num1 - num2;
            }
            case '+': {
                return num1 + num2;
            }
            case '%': {
                return num1 % num2;
            }
            case '*': {
                return new BigDecimal(num1 + "").multiply(new BigDecimal(num2 + "")).doubleValue();
            }
            case '/': {
                return new BigDecimal(num1).divide(new BigDecimal(num2), 2, RoundingMode.HALF_UP).doubleValue();
            }
            case '&': {
                return CalFun.booleanAndCal(num1, num2);
            }
            case '|': {
                return CalFun.booleanOrCal(num1, num2);
            }
        }
        return 0.0;
    }

    private static double booleanAndCal(double num1, double num2) {
        if (num1 == 1.0 && num2 == 1.0) {
            return 1.0;
        }
        return 0.0;
    }

    private static double booleanOrCal(double num1, double num2) {
        if (num1 == 0.0 && num2 == 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    public static double compute(ProcessContent content, String str) {
        double[] num = new double[20];
        boolean flag = false;
        int begin = 0;
        int end = 0;
        int now = -1;
        Stack<Character> st = new Stack<Character>();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char s = str.charAt(i2);
            if (s == ' ') continue;
            if (s == '+' || s == '-' || s == '*' || s == '/' || s == '(' || s == ')' || s == '%' || s == '&' || s == '|') {
                if (flag) {
                    String paramStr;
                    ++now;
                    if (end < begin) {
                        paramStr = str.substring(begin, begin + 1);
                        num[now] = CalFun.format(content, paramStr);
                    } else {
                        paramStr = str.substring(begin, end + 1);
                        num[now] = CalFun.format(content, paramStr);
                    }
                    flag = false;
                }
                if (s == '-') {
                    if (i2 == 0) {
                        flag = true;
                        begin = 0;
                        continue;
                    }
                    if (str.charAt(i2 - 1) == '(' || str.charAt(i2 - 1) == '*' || str.charAt(i2 - 1) == '/') {
                        flag = true;
                        begin = i2;
                        continue;
                    }
                    if (st.empty()) {
                        st.push(Character.valueOf(s));
                        continue;
                    }
                    if (s == ')') {
                        num[now - 1] = CalFun.compute(num[now - 1], num[now], ((Character)st.pop()).charValue());
                        --now;
                        st.pop();
                        continue;
                    }
                    if (s == '(') {
                        st.push(Character.valueOf(s));
                        continue;
                    }
                    if (CalFun.priority(s) <= CalFun.priority(((Character)st.peek()).charValue())) {
                        num[now - 1] = CalFun.compute(num[now - 1], num[now], ((Character)st.pop()).charValue());
                        --now;
                        st.push(Character.valueOf(s));
                        continue;
                    }
                    st.push(Character.valueOf(s));
                    continue;
                }
                if (st.empty()) {
                    st.push(Character.valueOf(s));
                    continue;
                }
                if (s == ')') {
                    num[now - 1] = CalFun.compute(num[now - 1], num[now], ((Character)st.pop()).charValue());
                    --now;
                    st.pop();
                    continue;
                }
                if (s == '(') {
                    st.push(Character.valueOf(s));
                    continue;
                }
                if (CalFun.priority(s) <= CalFun.priority(((Character)st.peek()).charValue())) {
                    num[now - 1] = CalFun.compute(num[now - 1], num[now], ((Character)st.pop()).charValue());
                    --now;
                    st.push(Character.valueOf(s));
                    continue;
                }
                st.push(Character.valueOf(s));
                continue;
            }
            if (!flag) {
                flag = true;
                begin = i2;
                continue;
            }
            end = i2;
        }
        if (flag) {
            ++now;
            if (end < begin) {
                String paramStr = str.substring(begin, begin + 1);
                num[now] = CalFun.format(content, paramStr);
            } else {
                String paramStr = str.substring(begin, end + 1);
                num[now] = CalFun.format(content, paramStr);
            }
        }
        while (now > 0) {
            num[now - 1] = CalFun.compute(num[now - 1], num[now], ((Character)st.pop()).charValue());
            --now;
        }
        return num[0];
    }

    private static double format(ProcessContent varContent, String aPam) {
        if (NumberUtils.isNumeric((String)aPam)) {
            return Double.valueOf(aPam);
        }
        Object value = varContent.getValue(aPam);
        if (value != null && NumberUtils.isNumeric((String)(value + ""))) {
            return Double.valueOf(value + "");
        }
        return 0.0;
    }

    public static void main(String[] args) {
        FunctionContent varContent = new FunctionContent();
        String exp = "(0 | 0) & 1";
    }
}

