/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.performance.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.performance.base.ConcurrentThread;
import com.manatee.performance.base.ConcurrentThreadV2;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.thread.util.ConcurrentUtil;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.MDC;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ConcurrentProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    protected final int WAIT_SECOND = 1000;

    public void process(ProcessContent content) throws BizException {
        int i;
        this.processConfUtil.checkConf(content, new String[]{"config"});
        JSONObject conf = content.getStepConf();
        JSONArray logicArray = conf.getJSONArray("config");
        CountDownLatch latch = new CountDownLatch(logicArray.size());
        TaskExecutor taskExecutor = ConcurrentUtil.getTaskExecutor();
        JSONObject tempModuleJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)content.getModule()));
        Long manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
        if (manateeProcessVersion != null && manateeProcessVersion >= 408030100L) {
            for (i = 0; i < logicArray.size(); ++i) {
                JSONObject aLogic = logicArray.getJSONObject(i);
                JSONObject paramsNew = JSONObject.parseObject((String)JSONObject.toJSONString((Object)content.getRequest()));
                ProcessContent contentTemp = new ProcessContent();
                contentTemp.setRequest((Map)paramsNew);
                contentTemp.setModule(tempModuleJson);
                contentTemp.setStep(content.getStep());
                ConcurrentThreadV2 thread = new ConcurrentThreadV2(content, contentTemp, aLogic, latch);
                taskExecutor.execute((Runnable)thread);
            }
        } else {
            for (i = 0; i < logicArray.size(); ++i) {
                JSONObject aLogic = logicArray.getJSONObject(i);
                String traceId = MDC.get((String)"traceId");
                ConcurrentThread thread = new ConcurrentThread(content, aLogic, latch, traceId);
                taskExecutor.execute((Runnable)thread);
            }
        }
        try {
            latch.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "CountDownLatch_exception", (Throwable)e);
        }
    }

    public String getName() {
        return "concurrentProcess";
    }
}

