/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.manager.COSFileUploadManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class COSLocalFileUploadProcess
implements IProcess {
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private COSFileUploadManager cosFileUploadManager;

    public void process(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String folder = this.variableUtil.calVarInConf(content, "folder");
        String localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        String needDel = this.variableUtil.calVarInConf(content, "needDel");
        InputStream inputStream = null;
        File file = null;
        try {
            file = new File(localFilePath);
            inputStream = new FileInputStream(file);
            String fileName = file.getName();
            String url = "";
            if (inputStream == null) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "file not found");
            }
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            url = this.cosFileUploadManager.uploadFile(inputStream, bucketName, folder, suffix);
            this.outputUtil.setDefaultReturnKey(content, "url");
            this.outputUtil.putData(content, (Object)url);
        }
        catch (FileNotFoundException e) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtil.isNotBlank((String)needDel) && "yes".equals(needDel) && file != null && file.exists()) {
                file.delete();
            }
        }
    }

    public String getName() {
        return "cosLocalFileUpload";
    }
}

