/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.crypto.SecureUtil;
import com.manatee.config.cos.CosConfig;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class COSFileUploadManager {
    @Resource
    private CosConfig cosConfig;

    public String uploadFile(InputStream file, String bucketName, String folder, String suffix) throws BizException {
        String url = "";
        COSClient COSClient2 = this.getCOSClient();
        String ownDomain = this.cosConfig.getOwnDomain();
        String endpoint = this.cosConfig.getEndpoint();
        try {
            if (!COSClient2.doesBucketExist(bucketName)) {
                COSClient2.createBucket(bucketName);
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)file);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = folder + this.buildFileName(new ByteArrayInputStream(fileBytes), suffix);
            if (!COSClient2.doesObjectExist(bucketName, fileName)) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileName, (InputStream)new ByteArrayInputStream(fileBytes), objectMetadata);
                COSClient2.putObject(putObjectRequest);
            }
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = endpoint;
            }
            url = ownDomain + "/" + fileName;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            COSClient2.shutdown();
        }
        return url;
    }

    public String uploadFileBase(String base, String bucketName, String folder, String suffix) throws BizException {
        String url = "";
        COSClient COSClient2 = this.getCOSClient();
        String ownDomain = this.cosConfig.getOwnDomain();
        try {
            if (!COSClient2.doesBucketExist(bucketName)) {
                COSClient2.createBucket(bucketName);
            }
            byte[] imageByte = Base64.getDecoder().decode(base);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = folder + this.buildBase64Name(imageByte, suffix);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageByte);
            if (!COSClient2.doesObjectExist(bucketName, fileName)) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                COSClient2.putObject(bucketName, fileName, (InputStream)byteArrayInputStream, objectMetadata);
            }
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.cosConfig.getEndpoint();
            }
            url = ownDomain + "/" + fileName;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            COSClient2.shutdown();
        }
        return url;
    }

    public String downloadFile(String bucketName, String cosFileName, String saveFile) throws BizException {
        COSClient COSClient2 = this.getCOSClient();
        String ownDomain = this.cosConfig.getOwnDomain();
        try {
            if (!COSClient2.doesBucketExist(bucketName)) {
                COSClient2.createBucket(bucketName);
            }
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.cosConfig.getEndpoint();
            }
            File downFile = new File(saveFile);
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, cosFileName);
            COSClient2.getObject(getObjectRequest, downFile);
            String string = saveFile;
            return string;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            COSClient2.shutdown();
        }
    }

    public void deleteFile(String bucketName, String cosFilePath) throws BizException {
        COSClient COSClient2 = this.getCOSClient();
        try {
            if (!COSClient2.doesBucketExist(bucketName)) {
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u6876\u540d\u79f0\u662f\u5426\u6b63\u786e");
            }
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, cosFilePath);
            COSClient2.deleteObject(deleteObjectRequest);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            COSClient2.shutdown();
        }
    }

    public String buildBase64Name(byte[] imageByte, String suffix) {
        try {
            String base64Str = Base64.getEncoder().encodeToString(imageByte);
            String fileName = SecureUtil.md5((String)base64Str);
            StringBuilder sb = new StringBuilder();
            sb.append(fileName);
            sb.append(".");
            sb.append(suffix);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String buildFileName(InputStream file, String suffix) {
        String fileName = SecureUtil.md5((InputStream)file);
        StringBuilder sb = new StringBuilder();
        sb.append(fileName);
        sb.append(".");
        sb.append(suffix);
        return sb.toString();
    }

    TransferManager createTransferManager() throws BizException {
        COSClient COSClient2 = this.getCOSClient();
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager((COS)COSClient2, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x500000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0x100000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }

    public COSClient getCustomCOSClient() throws BizException {
        return this.getCOSClient();
    }

    public COSClient getCOSClient() throws BizException {
        String region = this.cosConfig.getRegion();
        String secretId = this.cosConfig.getSecretId();
        String secretKey = this.cosConfig.getSecretKey();
        if (StringUtil.isBlank((String)region) || StringUtil.isBlank((String)secretId) || StringUtil.isBlank((String)secretKey)) {
            throw new BizException(ResultCode.CONF_ERROR, "cos region/secretId/secretKey \u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e");
        }
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region regionConf = new Region(region);
        ClientConfig clientConfig = new ClientConfig(regionConf);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient COSClient2 = new COSClient((COSCredentials)cred, clientConfig);
        return COSClient2;
    }

    public void setCosConfig(CosConfig cosConfig) {
        this.cosConfig = cosConfig;
    }
}

