/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.process;

import com.manatee.common.exception.BizException;
import com.manatee.elasticsearch.domain.ESUpdate;
import com.manatee.elasticsearch.manager.ESManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchUpdateProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    RestHighLevelClient restHighLevelClient;
    @Resource
    private ESManager esManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"index"});
        ESUpdate esUpdate = this.esManager.getESUpdate(content);
        BulkRequest request = this.getBulkRequest(esUpdate);
        BulkResponse bulkResponse = this.getBulkResponse(request);
        Object result = this.getResult(content, bulkResponse);
        this.outputUtil.putData(content, result);
    }

    private BulkRequest getBulkRequest(ESUpdate esUpdate) {
        BulkRequest request = new BulkRequest();
        String index = esUpdate.getIndex();
        String id = esUpdate.getId();
        Map<String, Object> updateColumns = esUpdate.getUpdateColumns();
        request.add(new UpdateRequest(index, id).doc(updateColumns, XContentType.JSON));
        return request;
    }

    private BulkResponse getBulkResponse(BulkRequest request) throws BizException {
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            return bulkResponse;
        }
        catch (IOException e) {
            BizException bizException = new BizException((Throwable)e);
            bizException.setMsg(e.getMessage());
            throw bizException;
        }
    }

    private Object getResult(ProcessContent content, BulkResponse bulkResponse) {
        this.outputUtil.setDefaultReturnKey(content, "count");
        BulkItemResponse[] items = bulkResponse.getItems();
        ArrayList<String> itemIds = new ArrayList<String>();
        for (BulkItemResponse item : items) {
            String result;
            DocWriteResponse response = item.getResponse();
            if (response == null || "not_found".equals(result = item.getResponse().getResult().getLowercase())) continue;
            itemIds.add(item.getId());
        }
        if (itemIds.size() > 0) {
            return itemIds.size();
        }
        return 0;
    }

    public String getName() {
        return "elasticsearchUpdate";
    }
}

