/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.graphs.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.graphs.data.GraphsData;
import com.manatee.lowcode.graphs.vo.ManateeGraphVo;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindGraphsNodesProcess
implements IProcess {
    @Autowired
    private GraphsData graphsData;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"bizType"});
        this.processConfUtil.checkConf(content, new String[]{"nodeId"});
        this.processConfUtil.checkConf(content, new String[]{"portionId"});
        String bizType = this.variableUtil.calVarInConf(content, "bizType");
        String nodeId = this.variableUtil.calVarInConf(content, "nodeId");
        String portionId = this.variableUtil.calVarInConf(content, "portionId");
        ManateeGraphVo nodes = this.graphsData.getNodes(Long.valueOf(portionId), Long.parseLong(nodeId), Integer.parseInt(bizType));
        JSONObject result = (JSONObject)JSONObject.toJSON((Object)nodes);
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "findGraphsNodesProcess";
    }
}

