/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rocketmq.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.rocketmq.config.ManateeRocketmqProducerConfig;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RocketmqProducerProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RocketmqProducerProcess.class);
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"topic"});
        String topic = this.variableUtil.calVarInConf(content, "topic");
        String tags = this.variableUtil.calVarInConf(content, "tags");
        String uniqueid = this.variableUtil.calVarInConf(content, "uniqueid");
        Map value = this.inputUtil.getHandleObject(content, "value");
        JSONObject valueJson = new JSONObject(true);
        valueJson.putAll(value);
        if (StringUtil.isNotBlank((String)uniqueid)) {
            valueJson.put("_uniqueid", (Object)uniqueid);
        }
        String group = this.variableUtil.calVarInConf(content, "group");
        try {
            DefaultMQProducer producer = null;
            Map<String, DefaultMQProducer> producerMap = ManateeRocketmqProducerConfig.producerMap;
            producer = StringUtils.isBlank((CharSequence)group) ? producerMap.get(ManateeRocketmqProducerConfig.firstGroup) : producerMap.get(group);
            Message msg = new Message(topic, tags, uniqueid, valueJson.toJSONString().getBytes("UTF-8"));
            SendResult sendResult = producer.send(msg, 10000L);
            this.log.warn("rocketmq producer success", (Object)sendResult);
        }
        catch (Exception e) {
            this.log.error("rocketmq producer\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException(ResultCode.SYSTEM_ERROR, "rocketmqProducer error");
        }
    }

    public String getName() {
        return "rocketmqProducer";
    }
}

