/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.mongo.MongoWriteUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoDeleteProcess
implements IProcess {
    @Resource
    private IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private MongoWriteUtil mongoWriteUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        this.processConfUtil.checkConf(content, new String[]{"table"});
        this.deleteData(content, conf);
    }

    public void deleteData(ProcessContent content, JSONObject conf) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        String table = conf.getString("table");
        Map queryParam = this.inputUtil.getHandleObject(content);
        if (queryParam == null || queryParam.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        long deletedCount = this.mongoWriteUtil.delete(db, table, queryParam);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.handleAndPutData(content, (Object)deletedCount);
    }

    public String getName() {
        return "mongoDelete";
    }
}

