/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.In;
import com.manatee.common.domain.Page;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.mongo.MongoClientInit;
import com.manatee.mongo.domain.GreaterBO;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoReadBase {
    @Resource
    private MongoClientInit mongoClientInit;

    protected Integer findTotalCountWithDB(DBQuery dbQuery) {
        JSONArray array = new JSONArray();
        Map conditionMap = dbQuery.getConditionMap();
        this.initIn(dbQuery);
        this.initGreater(dbQuery);
        Document document = new Document();
        for (Map.Entry map : conditionMap.entrySet()) {
            if (map.getKey() == null) continue;
            if (map.getValue() == null) {
                document.put((String)map.getKey(), null);
                continue;
            }
            if (ObjectId.isValid((String)map.getValue().toString())) {
                document.put((String)map.getKey(), (Object)new ObjectId(map.getValue().toString()));
                continue;
            }
            document.put((String)map.getKey(), map.getValue());
        }
        Document conditionDoc = new Document((Map)document);
        BasicDBObject queryCondition = new BasicDBObject();
        queryCondition.putAll(conditionMap);
        BasicDBObject fieldFilter = new BasicDBObject();
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(dbQuery.getDb(), dbQuery.getTable());
        FindIterable findIterable = mongoCollection.find((Bson)conditionDoc).projection((Bson)fieldFilter);
        for (Document doc : findIterable) {
            if (doc == null) continue;
            JSONObject one = new JSONObject();
            array.add((Object)one);
        }
        return array.size();
    }

    protected JSONArray findListWithDB(DBQuery dbQuery) {
        JSONArray array = new JSONArray();
        Map conditionMap = dbQuery.getConditionMap();
        Bson sortBson = this.getSort(dbQuery);
        this.initIn(dbQuery);
        this.initGreater(dbQuery);
        Integer pageNum = null;
        Integer limit = null;
        Integer skip = null;
        Page page = dbQuery.getPage();
        if (page != null) {
            pageNum = page.getPageNum();
            limit = page.getPageSize();
        }
        if (page != null && limit != null) {
            skip = (pageNum - 1) * limit;
        }
        Document document = new Document();
        for (Map.Entry map : conditionMap.entrySet()) {
            if (map.getKey() == null) continue;
            if (map.getValue() == null) {
                document.put((String)map.getKey(), null);
                continue;
            }
            if (ObjectId.isValid((String)map.getValue().toString())) {
                document.put((String)map.getKey(), (Object)new ObjectId(map.getValue().toString()));
                continue;
            }
            document.put((String)map.getKey(), map.getValue());
        }
        Document conditionDoc = new Document((Map)document);
        BasicDBObject fieldFilter = new BasicDBObject();
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String columns = dbQuery.getColumns().replaceAll(" ", "");
            List<String> fields = Arrays.asList(columns.split(","));
            if (!fields.contains("_id")) {
                fieldFilter.append("_id", (Object)0);
            }
            for (int i = 0; i < fields.size(); ++i) {
                fieldFilter.append(fields.get(i), (Object)1);
            }
        }
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(dbQuery.getDb(), dbQuery.getTable());
        FindIterable findIterable = mongoCollection.find((Bson)conditionDoc).projection((Bson)fieldFilter);
        if (sortBson != null) {
            findIterable.sort(sortBson);
        }
        if (skip != null) {
            findIterable.skip(skip.intValue());
        }
        if (limit != null) {
            findIterable.limit(limit.intValue());
        }
        for (Document doc : findIterable) {
            if (doc == null) continue;
            JSONObject one = new JSONObject();
            for (Map.Entry stringObjectEntry : doc.entrySet()) {
                if (stringObjectEntry.getValue() != null) {
                    if (ObjectId.isValid((String)stringObjectEntry.getValue().toString())) {
                        stringObjectEntry.setValue(stringObjectEntry.getValue() + "");
                    } else if (stringObjectEntry.getValue() instanceof Date) {
                        stringObjectEntry.setValue(DateUtils.DateToStr((Date)((Date)stringObjectEntry.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                }
                one.put((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
            array.add((Object)one);
        }
        return array;
    }

    protected void initIn(DBQuery dbQuery) {
        List inList = dbQuery.getIn();
        if (inList == null || inList.size() == 0) {
            return;
        }
        for (In in : inList) {
            if (in == null) {
                return;
            }
            String inKey = in.getKey();
            if (StringUtil.isBlank((String)inKey)) {
                return;
            }
            ArrayList<Object> value = new ArrayList<Object>();
            for (int i = 0; i < in.getValue().size(); ++i) {
                if (ObjectId.isValid((String)in.getValue().get(i).toString())) {
                    value.add(new ObjectId(in.getValue().get(i).toString()));
                    continue;
                }
                value.add(in.getValue().get(i));
            }
            BasicDBList basicValues = new BasicDBList();
            basicValues.addAll(value);
            BasicDBObject list = new BasicDBObject("$in", (Object)basicValues);
            dbQuery.putConditionMap(inKey.trim(), (Object)list);
        }
    }

    protected void initJoin(DBQuery dbQuery) {
        JSONArray joinArray = dbQuery.getJoin();
        if (joinArray == null || joinArray.size() == 0) {
            return;
        }
    }

    protected void initGreater(DBQuery dbQuery) {
        String conditionStr = dbQuery.getCondition();
        if (conditionStr != null) {
            Map conditionMap = dbQuery.getConditionMap();
            this.initLogic(conditionMap, conditionStr, "and");
            this.initLogic(conditionMap, conditionStr, "or");
            this.initGreater(conditionMap, conditionStr);
        }
    }

    private void initLogic(Map<String, Object> condition, String expStr, String symbol) {
        String symbolStr = " " + symbol + " ";
        if (expStr.indexOf(symbolStr) != -1) {
            ArrayList<BasicDBObject> values = new ArrayList<BasicDBObject>();
            String[] exps = expStr.trim().split(symbolStr);
            for (int i = 0; i < exps.length; ++i) {
                String exp = exps[i];
                GreaterBO greaterBO = this.getGreaterBO(exp);
                if (greaterBO == null) continue;
                if ("=".equals(greaterBO.getSymbol())) {
                    values.add(new BasicDBObject(greaterBO.getKey(), greaterBO.getValue()));
                    continue;
                }
                values.add(new BasicDBObject(greaterBO.getKey(), (Object)new BasicDBObject(greaterBO.getSymbol(), greaterBO.getValue())));
            }
            condition.put("$" + symbol, values);
        }
    }

    private void initGreater(Map<String, Object> condition, String expStr) {
        if (condition.get("$and") != null || condition.get("$or") != null) {
            return;
        }
        GreaterBO greaterBO = this.getGreaterBO(expStr);
        if (greaterBO == null) {
            return;
        }
        if ("=".equals(greaterBO.getSymbol())) {
            condition.put(greaterBO.getKey(), greaterBO.getValue());
            return;
        }
        BasicDBObject dbObject = new BasicDBObject(greaterBO.getSymbol(), greaterBO.getValue());
        condition.put(greaterBO.getKey(), dbObject);
    }

    private List<ObjectId> getObjectIdList(List<String> value) {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (String str : value) {
            ObjectId id = new ObjectId(str);
            objectIds.add(id);
        }
        return objectIds;
    }

    private GreaterBO getGreaterBO(String exp) {
        GreaterBO greaterBO = new GreaterBO();
        String symbol = null;
        if (exp.indexOf(">=") != -1) {
            symbol = ">=";
            greaterBO.setSymbol("$gte");
        } else if (exp.indexOf("<=") != -1) {
            symbol = "<=";
            greaterBO.setSymbol("$lte");
        } else if (exp.indexOf(">") != -1) {
            symbol = ">";
            greaterBO.setSymbol("$gt");
        } else if (exp.indexOf("<") != -1) {
            symbol = "<";
            greaterBO.setSymbol("$lt");
        } else if (exp.indexOf("!=") != -1) {
            symbol = "!=";
            greaterBO.setSymbol("$ne");
        } else if (exp.indexOf("=") != -1) {
            symbol = "=";
            greaterBO.setSymbol("=");
        } else if (exp.indexOf("like") != -1) {
            symbol = "like";
            greaterBO.setSymbol("$regex");
        } else {
            return null;
        }
        String[] exps = exp.split(symbol);
        greaterBO.setKey(exps[0].trim());
        if (exps.length == 1) {
            return greaterBO;
        }
        if ("null".equals(exps[1].trim())) {
            exps[1] = null;
        } else {
            if (exps[1].trim().startsWith("'") && exps[1].trim().endsWith("'")) {
                exps[1] = exps[1].trim().substring(1, exps[1].trim().length() - 1);
            }
            if (exps[1].trim().startsWith("%") && exps[1].trim().endsWith("%")) {
                exps[1] = exps[1].substring(1, exps[1].length() - 1);
            }
        }
        greaterBO.setValue(exps[1] == null ? null : exps[1].trim());
        return greaterBO;
    }

    public Bson getSort(DBQuery dbQuery) {
        Map sortMap = dbQuery.getSort();
        if (sortMap == null) {
            return null;
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        for (Map.Entry aMap : sortMap.entrySet()) {
            String mapKey = (String)aMap.getKey();
            String value = (aMap.getValue() + "").toLowerCase();
            Integer sortType = "asc".equals(value) ? 1 : -1;
            basicDBObject.put((Object)mapKey, (Object)sortType);
        }
        BasicDBObject sortBson = basicDBObject;
        return sortBson;
    }
}

