/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.ChannelSftpFactory;
import com.manatee.file.base.SftpUtils;
import com.manatee.lowcode.process.store.handle.ManateeFileHandle;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SftpUploadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(SftpUploadProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ChannelSftpFactory channelSftpFactory;
    @Resource
    private ManateeFileHandle manateeFileHandle;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"remotePath"});
        String remotePath = this.variableUtil.calVarInConf(content, "remotePath");
        String fileSource = content.getStepConf().getString("fileSource");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        Boolean needMakeDirectory = content.getStepConf().getBoolean("needMakeDirectory");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        needMakeDirectory = needMakeDirectory == null ? Boolean.FALSE : needMakeDirectory;
        ArrayList fileInfos = new ArrayList();
        this.manateeFileHandle.getContentFiles(content, fileSource, needDel, autoCover, fileInfos);
        Session sshSession = null;
        ChannelSftp channelSftp = this.channelSftpFactory.sftpConnection(sshSession, content);
        try {
            for (ProcessFileInfo fileInfo : fileInfos) {
                SftpUtils.upload(remotePath, fileInfo.getFileName(), fileInfo.getInputStream(), channelSftp, needMakeDirectory);
                Boolean needDel1 = fileInfo.getNeedDel();
                File file = fileInfo.getFile();
                if (!needDel1.booleanValue() || file == null || !file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("SftpDownloadProcess \u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BizException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 :" + e.getMessage());
        }
        finally {
            SftpUtils.sftpClose(channelSftp);
            SftpUtils.sessionClose(sshSession);
        }
    }

    public String getName() {
        return "sftpUpload";
    }
}

