/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.base;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(SftpUtils.class);

    public static ChannelSftp sftpConnection(Session sshSession, String host, int port, String userName, String password) throws BizException {
        ChannelSftp channelSftp;
        JSch jsch = new JSch();
        try {
            jsch.getSession(userName, host, port);
            sshSession = jsch.getSession(userName, host, port);
            sshSession.setPassword(password);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(properties);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            LOGGER.error("Sftp\u670d\u52a1\u5668\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            throw new BizException("Sftp\u670d\u52a1\u5668\u767b\u5f55\u5f02\u5e38!");
        }
        return channelSftp;
    }

    public static void sftpClose(ChannelSftp channelSftp) {
        if (channelSftp != null && channelSftp.isConnected()) {
            channelSftp.disconnect();
        }
    }

    public static void sessionClose(Session sshSession) {
        if (sshSession != null && sshSession.isConnected()) {
            sshSession.disconnect();
        }
    }

    public static void upload(String directory, String sftpFileName, InputStream input, ChannelSftp channelSftp, Boolean needMakeDirectory) throws Exception {
        boolean directoryExist = true;
        try {
            channelSftp.cd(directory);
        }
        catch (SftpException e) {
            directoryExist = false;
        }
        if (!directoryExist && needMakeDirectory.booleanValue()) {
            channelSftp.mkdir(directory);
            channelSftp.cd(directory);
        }
        if (!directoryExist && !needMakeDirectory.booleanValue()) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u3010" + directory + "\u3011,directory does not exist");
        }
        try {
            channelSftp.put(input, sftpFileName);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.warn("SftpUtils close error", (Throwable)e);
                }
            }
        }
    }

    public static void upload(String directory, String uploadFile, ChannelSftp channelSftp, Boolean needMakeDirectory) throws Exception {
        File file = new File(uploadFile);
        SftpUtils.upload(directory, file.getName(), new FileInputStream(file), channelSftp, needMakeDirectory);
    }

    public static void upload(String directory, String sftpFileName, byte[] byteArr, ChannelSftp channelSftp, Boolean needMakeDirectory) throws Exception {
        SftpUtils.upload(directory, sftpFileName, new ByteArrayInputStream(byteArr), channelSftp, needMakeDirectory);
    }

    public static void upload(String directory, String sftpFileName, String dataStr, String charsetName, ChannelSftp channelSftp, Boolean needMakeDirectory) throws Exception {
        SftpUtils.upload(directory, sftpFileName, new ByteArrayInputStream(dataStr.getBytes(charsetName)), channelSftp, needMakeDirectory);
    }

    public static void download(String directory, String downloadFile, String saveFile, ChannelSftp channelSftp) throws SftpException, FileNotFoundException {
        if (directory != null && !"".equals(directory)) {
            channelSftp.cd(directory);
        }
        File file = new File(saveFile);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            channelSftp.get(downloadFile, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            LOGGER.error("download file error", (Throwable)e);
            throw e;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("SftpUtils close error", (Throwable)e);
                }
            }
        }
    }
}

