/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.base;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FtpUtilsFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(FtpUtilsFactory.class);
    @Resource
    private ManateeConfig manateeConfig;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    public String LOCAL_CHARSET = "GBK";

    public FTPClient connectServer(ProcessContent content) throws BizException {
        String ftpIp = null;
        Integer ftpPort = null;
        String ftpUser = null;
        String ftpPwd = null;
        String configureType = content.getStepConf().getString("configureType");
        if (StringUtil.isNotBlank((String)configureType) && "system".equals(configureType)) {
            ftpIp = this.manateeConfig.getFtp().getIp();
            ftpPort = this.manateeConfig.getFtp().getPort();
            ftpUser = this.manateeConfig.getFtp().getUser();
            ftpPwd = this.manateeConfig.getFtp().getPassword();
        } else {
            this.processConfUtil.checkConf(content, new String[]{"ftpIp"});
            this.processConfUtil.checkConf(content, new String[]{"ftpPort"});
            this.processConfUtil.checkConf(content, new String[]{"ftpUser"});
            this.processConfUtil.checkConf(content, new String[]{"ftpPwd"});
            ftpIp = this.variableUtil.calVarInConf(content, "ftpIp");
            String ftpPortStr = this.variableUtil.calVarInConf(content, "ftpPort");
            if (StringUtil.isNotBlank((String)ftpPortStr)) {
                ftpPort = Integer.parseInt(ftpPortStr);
            }
            ftpUser = this.variableUtil.calVarInConf(content, "ftpUser");
            ftpPwd = this.variableUtil.calVarInConf(content, "ftpPwd");
        }
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.setCharset(CharsetUtil.charset((String)"UTF-8"));
            ftpClient.setAutodetectUTF8(true);
            ftpClient.connect(ftpIp, ftpPort.intValue());
            Boolean isSuccess = ftpClient.login(ftpUser, ftpPwd);
            if (!isSuccess.booleanValue()) {
                LOGGER.error("\u8fde\u63a5ftp\u670d\u52a1\u5668\u5931\u8d25 \u670d\u52a1\u5668\u5730\u5740\u3010 {}\u3011", (Object)ftpIp);
                throw new BizException(ResultCode.CONF_ERROR, "\u8fde\u63a5ftp\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8", "ON"))) {
                this.LOCAL_CHARSET = "UTF-8";
            }
            ftpClient.setControlEncoding(this.LOCAL_CHARSET);
            ftpClient.enterLocalPassiveMode();
        }
        catch (IOException e) {
            LOGGER.error("\u8fde\u63a5ftp\u670d\u52a1\u5668\u5931\u8d25 \u670d\u52a1\u5668\u5730\u5740 \u3010{}\u3011 \u5f02\u5e38{}", (Object)ftpIp, (Object)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u8fde\u63a5ftp\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
        }
        return ftpClient;
    }

    public static boolean disconnect(FTPClient ftpClient) {
        try {
            ftpClient.logout();
            ftpClient.disconnect();
        }
        catch (IOException e) {
            LOGGER.error("ftp\u670d\u52a1\u5668\u65ad\u5f00\u5931\u8d25 \u5f02\u5e38{}", (Throwable)e);
        }
        return FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode());
    }
}

