/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sms.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.sms.manager.AliyunSmsManager;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendSmsProcess
implements IProcess {
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private AliyunSmsManager aliyunSmsManager;
    private final String ALIYUN = "aliyun";

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"phoneNumbers"});
        this.processConfUtil.checkConf(content, new String[]{"signName"});
        this.processConfUtil.checkConf(content, new String[]{"templateCode"});
        String smsType = this.variableUtil.calVarInConf(content, "smsType");
        String phoneNumbers = this.variableUtil.calVarInConf(content, "phoneNumbers");
        String signName = this.variableUtil.calVarInConf(content, "signName");
        String templateCode = this.variableUtil.calVarInConf(content, "templateCode");
        String paramType = content.getStepConfString("paramType");
        String templateParamsStr = null;
        if (StringUtil.isBlank((String)paramType) || paramType.equals("map")) {
            String syntaxType = content.getStepConf().getString("syntaxType");
            Map templateParams = this.inputUtil.getHandleObjectV2(content, "templateParam", syntaxType);
            if (templateParams != null) {
                templateParamsStr = JSONObject.toJSONString((Object)templateParams);
            }
        } else {
            String key = this.variableUtil.calVarInConf(content, "jsonValue");
            Object jsonObj = content.getValue(key);
            templateParamsStr = JSONObject.toJSONString((Object)jsonObj);
        }
        JSONObject result = new JSONObject();
        if (StringUtils.equals((CharSequence)smsType, (CharSequence)"aliyun")) {
            result = this.aliyunSmsManager.sendSms(phoneNumbers, signName, templateCode, templateParamsStr);
        }
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "sendSmsProcess";
    }
}

