/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dubbo.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.dubbo.config.ManateeDubboConsumerConfig;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DubboConsumerPocess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(DubboConsumerPocess.class);
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private ManateeDubboConsumerConfig manateeDubboConsumerConfig;
    @Resource
    private VariableUtil variableUtil;
    @Value(value="${manatee.dubbo.timeout:3000}")
    private Integer callTimeout;

    public void process(ProcessContent content) throws BizException {
        Object result;
        this.processConfUtil.checkConf(content, new String[]{"interfaceName"});
        String versionObj = this.variableUtil.calVarInConf(content, "version");
        String version = null;
        if (versionObj != null && StringUtil.isNotBlank((String)versionObj.toString())) {
            version = this.variableUtil.calVarInConf(content, "version");
        }
        String groupObj = this.variableUtil.calVarInConf(content, "group");
        String group = null;
        if (groupObj != null && StringUtil.isNotBlank((String)groupObj.toString())) {
            group = this.variableUtil.calVarInConf(content, "group");
        }
        String interfaceName = this.variableUtil.calVarInConf(content, "interfaceName");
        String method = this.variableUtil.calVarInConf(content, "method");
        Object additionalInformation = content.getStepConf().get((Object)"additionalInformation");
        GenericService genericService = this.getGenericService(version, group, interfaceName, additionalInformation, content);
        Object[] argsArr = null;
        String[] parameterTypesArr = null;
        Map args = this.inputUtil.getHandleObject(content, "args");
        if (interfaceName.indexOf(".ManateeDubboService") != -1 && method.equals("executionModule")) {
            argsArr = new Object[3];
            parameterTypesArr = new String[3];
            argsArr[0] = this.variableUtil.calVarInConf(content, "lowcodeProjectId");
            argsArr[1] = this.variableUtil.calVarInConf(content, "lowcodeModule");
            argsArr[2] = args;
            parameterTypesArr[0] = "java.lang.Long";
            parameterTypesArr[1] = "java.lang.String";
            parameterTypesArr[2] = "java.util.Map";
            Map modularityResult = (Map)genericService.$invoke(method, parameterTypesArr, argsArr);
            result = modularityResult.get("data");
        } else {
            Map parameterTypes = this.inputUtil.getHandleObject(content, "parameterTypes");
            if (args.size() > 0) {
                argsArr = args.values().toArray();
            }
            if (parameterTypes.size() > 0) {
                parameterTypesArr = parameterTypes.values().toArray(new String[parameterTypes.size()]);
            }
            result = genericService.$invoke(method, parameterTypesArr, argsArr);
        }
        this.outputUtil.putData(content, result);
    }

    public String getName() {
        return "dubboConsumer";
    }

    private GenericService getGenericService(String version, String group, String interfaceName, Object additionalInformations, ProcessContent content) {
        JSONArray joinJsonArr;
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(this.manateeDubboConsumerConfig.getDubboApplicationConfig());
        if (StringUtil.isNotBlank((String)version)) {
            reference.setVersion(version);
        }
        if (StringUtil.isNotBlank((String)group)) {
            reference.setGroup(group);
        }
        reference.setInterface(interfaceName);
        if (additionalInformations != null && CollectionUtils.isNotEmpty((Collection)(joinJsonArr = JSONArray.parseArray((String)JSON.toJSONString((Object)additionalInformations))))) {
            for (Object entry : joinJsonArr) {
                JSONObject object = (JSONObject)entry;
                String key = object.getString("key");
                String val = object.getString("val");
                key = this.variableUtil.calVar(content, key);
                val = this.variableUtil.calVar(content, val);
                RpcContext.getContext().setAttachment(key, val);
            }
        }
        reference.setTimeout(this.getTimeout(content));
        reference.setGeneric(Boolean.valueOf(true));
        ReferenceConfigCache cache = ReferenceConfigCache.getCache();
        GenericService genericService = (GenericService)cache.get((ReferenceConfigBase)reference);
        return genericService;
    }

    private Integer getTimeout(ProcessContent content) {
        String timeoutStr = this.variableUtil.calVarInConf(content, "timeout");
        if (StringUtil.isNotBlank((String)timeoutStr) && NumberUtils.isNumber((String)timeoutStr)) {
            return Integer.valueOf(timeoutStr);
        }
        return this.callTimeout;
    }
}

