/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dameng.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.In;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.MapUtils;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.dameng.init.DamengTableFieldsInfo;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="dameng")
public class DamengDBHandle
extends DBHandle {
    private static final Logger log = LoggerFactory.getLogger(DamengDBHandle.class);
    @Value(value="${spring.datasource.url}")
    public String datasourceUrl;
    @Value(value="${spring.datasource.username}")
    public String datasourceUsername;
    @Resource
    private DamengTableFieldsInfo damengTableFieldsInfo;

    public String getName() {
        return "dameng,dm dbms";
    }

    public PreparedStatement getPreparedStatement(Connection con, StringBuilder sqlSB) throws SQLException {
        return con.prepareStatement(sqlSB.toString(), 1);
    }

    public StringBuilder initColumnsSql(StringBuilder sqlSB, DBQuery dbQuery) {
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String[] columns = dbQuery.getColumns().split(",");
            List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), dbQuery.getTable());
            for (String column : columns) {
                column = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), dbQuery.getTable(), column);
                sqlSB.append(column).append(",");
            }
            if (columns.length > 0) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 1));
            }
        }
        return sqlSB;
    }

    public StringBuilder initAppendTableSql(StringBuilder sqlSB, String table, Connection con) {
        String db = this.getSchema(con);
        table = this.getTableStr(con, db, table);
        sqlSB.append(db).append(".").append(table);
        return sqlSB;
    }

    public StringBuilder initConditionMapSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Map conditionMap = dbQuery.getConditionMap();
        if (conditionMap != null && conditionMap.size() != 0) {
            sqlSB.append(" where ");
            List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), dbQuery.getTable());
            for (Map.Entry aMap : conditionMap.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                String key = ((String)aMap.getKey()).trim();
                key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), dbQuery.getTable(), key);
                sqlSB.append(key).append("=?").append(" and ");
            }
            if (sqlSB.substring(sqlSB.length() - 5).equals(" and ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 5));
            }
            if (sqlSB.substring(sqlSB.length() - 7).equals(" where ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 7));
            }
        }
        return sqlSB;
    }

    public StringBuilder initJoinSql(StringBuilder sqlSB, DBQuery dbQuery, Connection con) {
        if (CollectionUtils.isEmpty((Collection)dbQuery.getJoin())) {
            return sqlSB;
        }
        dbQuery.setDb(this.getSchema(con));
        List<String> joinFieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), dbQuery.getTable());
        sqlSB = new StringBuilder("select ");
        String tableAlias = dbQuery.getTable();
        String table = this.getTableStr(con, dbQuery.getDb(), tableAlias);
        ArrayList<String> fieldNameList = new ArrayList<String>();
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String[] fields = dbQuery.getColumns().split(",");
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i].trim();
                field = this.getColumnKeyStr(joinFieldsByDatabaseName, con, dbQuery.getDb(), dbQuery.getTable(), field);
                fieldNameList.add(table + "." + field);
            }
        } else {
            fieldNameList.add(table + ".*");
        }
        JSONArray joinArray = dbQuery.getJoin();
        StringBuilder joinSb = new StringBuilder();
        if (joinArray != null) {
            for (int i = 0; i < joinArray.size(); ++i) {
                JSONObject joinConf = joinArray.getJSONObject(i);
                String beJoinTable = joinConf.getString("table");
                beJoinTable = this.getTableStr(con, dbQuery.getDb(), beJoinTable);
                StringBuilder rightTableSelectSb = new StringBuilder(dbQuery.getDb() + "." + beJoinTable);
                String rightTable = joinConf.getString("table");
                JSONObject joinQueryParams = joinConf.getJSONObject("queryParams");
                List<String> beJoinedFieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), rightTable);
                String rightTableStr = this.getTableStr(con, dbQuery.getDb(), rightTable);
                if (MapUtils.isNotEmpty((Map)joinQueryParams)) {
                    rightTableSelectSb = new StringBuilder("(select * from " + dbQuery.getDb() + "." + rightTableStr + " where ");
                    String joinCondition = joinQueryParams.getString("condition");
                    if (StringUtil.isNotEmpty((CharSequence)joinCondition)) {
                        rightTableSelectSb.append(joinCondition).append(" and ");
                        joinQueryParams.remove((Object)"condition");
                    }
                    for (Map.Entry aMap : joinQueryParams.entrySet()) {
                        Object value = aMap.getValue();
                        if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                        String key = ((String)aMap.getKey()).trim();
                        key = this.getColumnKeyStr(beJoinedFieldsByDatabaseName, con, dbQuery.getDb(), rightTable, key);
                        rightTableSelectSb.append(key).append("=?").append(" and ");
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 5).equals(" and ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 5));
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 7).equals(" where ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 7));
                    }
                    rightTableSelectSb.append(")");
                }
                String joinKey = joinConf.getString("joinKey");
                joinKey = this.getColumnKeyStr(joinFieldsByDatabaseName, con, dbQuery.getDb(), dbQuery.getTable(), joinKey);
                String beJoinedKey = joinConf.getString("beJoinedKey");
                beJoinedKey = this.getColumnKeyStr(beJoinedFieldsByDatabaseName, con, dbQuery.getDb(), rightTable, beJoinedKey);
                String joinType = joinConf.getString("joinType");
                if (StringUtil.isNotEmpty((CharSequence)joinType)) {
                    joinSb.append(" ").append(joinType).append(" ");
                } else {
                    joinSb.append(" JOIN ");
                }
                joinSb.append((CharSequence)rightTableSelectSb).append(" ").append(rightTableStr).append(" ON ").append(table).append(".").append(joinKey).append(" = ").append(rightTableStr).append(".").append(beJoinedKey);
                String rightTableColumns = joinConf.getString("columns");
                if (!StringUtil.isNotEmpty((CharSequence)rightTableColumns)) continue;
                String[] rightTableFields = rightTableColumns.split(",");
                for (int j = 0; j < rightTableFields.length; ++j) {
                    String rightTableFieldName;
                    String[] rtfnArr = rightTableFields[j].trim().split(" ");
                    if (rtfnArr.length <= 1) {
                        rightTableFieldName = rightTable.startsWith("\"") && rightTable.endsWith("\"") ? rightTable.substring(1, rightTable.length() - 1) + "_" : rightTable + "_";
                        rightTableFieldName = rightTableFields[j].startsWith("\"") && rightTableFields[j].endsWith("\"") ? rightTableFieldName + rightTableFields[j].substring(1, rightTableFields[j].length() - 1) + "_" : rightTableFieldName + rightTableFields[j];
                    } else {
                        rightTableFieldName = rightTableFields[j].replaceFirst(rtfnArr[0], "");
                    }
                    String key = rtfnArr[0];
                    key = this.getColumnKeyStr(beJoinedFieldsByDatabaseName, con, dbQuery.getDb(), rightTable, key);
                    fieldNameList.add(rightTableStr + "." + key + " " + rightTableFieldName);
                }
            }
        }
        for (int i = 0; i < fieldNameList.size(); ++i) {
            sqlSB.append((String)fieldNameList.get(i));
            if (i >= fieldNameList.size() - 1) continue;
            sqlSB.append(",");
        }
        sqlSB.append(" from ").append(dbQuery.getDb()).append(".").append(table).append(" ").append(table);
        sqlSB.append((CharSequence)joinSb);
        this.handleFieldPrefixForJoin(dbQuery);
        return sqlSB;
    }

    public void handleFieldPrefixForJoin(DBQuery dbQuery) {
        Map sort;
        List inList;
        String condition;
        String tableAlias = dbQuery.getTable();
        String table = this.getTableStr(null, dbQuery.getDb(), tableAlias);
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), tableAlias);
        Map conditionMap = dbQuery.getConditionMap();
        if (MapUtil.isNotEmpty((Map)conditionMap)) {
            HashMap conditionMapJoin = new HashMap();
            for (String key : conditionMap.keySet()) {
                Object value = conditionMap.get(key);
                key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), tableAlias, key);
                conditionMapJoin.put(table + "." + key, value);
            }
            dbQuery.setConditionMap(conditionMapJoin);
        }
        if (StrUtil.isNotEmpty((CharSequence)(condition = dbQuery.getCondition()))) {
            StringBuilder fieldConditionSb = new StringBuilder();
            String[] andArr = condition.split(" and ");
            for (int k = 0; k < andArr.length; ++k) {
                String[] orArr = ((String)andArr[k]).split(" or ");
                for (int j = 0; j < orArr.length; ++j) {
                    String key = orArr[j];
                    key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), tableAlias, key);
                    fieldConditionSb.append(" ").append(table).append(".").append(key);
                    if (j >= orArr.length - 1) continue;
                    fieldConditionSb.append(" ").append("or");
                }
                if (k >= andArr.length - 1) continue;
                fieldConditionSb.append(" ").append("and");
            }
            String conditionJoin = fieldConditionSb.toString();
            dbQuery.setCondition(conditionJoin);
        }
        if (ArrayUtil.isNotEmpty((Object)(inList = dbQuery.getIn()))) {
            for (In in : inList) {
                String key = in.getKey();
                key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), tableAlias, key);
                in.setKey(table + "." + key);
            }
        }
        if (MapUtil.isNotEmpty((Map)(sort = dbQuery.getSort()))) {
            HashMap sortJoin = new HashMap();
            Iterator iterator = sort.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String keyStr = key = (String)iterator.next();
                key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), tableAlias, key);
                sortJoin.put(table + "." + keyStr, sort.get(key));
            }
            dbQuery.setSort(sortJoin);
        }
    }

    public StringBuilder initSchemaSql(Connection con, StringBuilder sqlSb, String schema) throws SQLException {
        sqlSb.append("SELECT DISTINCT owner as table_schema from all_tab_columns t WHERE 1 = 1 ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND t.owner LIKE ").append("'%").append(schema).append("%'");
        }
        return sqlSb;
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) {
        if (StringUtil.isBlank((String)schema)) {
            schema = this.getSchema(con);
        }
        sqlSb.append("SELECT a.table_name, b.column_name FROM (SELECT DISTINCT table_name from all_tab_columns where owner = '").append(schema).append("' ");
        if (StringUtil.isNotBlank((String)table)) {
            sqlSb.append("AND TABLE_NAME LIKE ").append("'%").append(table).append("%' ");
        }
        sqlSb.append("LIMIT 10) a JOIN (SELECT table_name, column_name, column_id from all_tab_columns where owner = '").append(schema).append("') b ON a.table_name = b.table_name ");
        sqlSb.append("order by b.column_id ");
        return sqlSb;
    }

    public StringBuilder initInsertConditionSql(DBInsert insert, Connection con) throws SQLException {
        String insertType = insert.getInsertType();
        StringBuilder sqlSb = new StringBuilder();
        String pkName = insert.getPkName();
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(insert.getDb(), insert.getTable());
        if (StringUtil.isNotBlank((String)pkName) && !pkName.startsWith("\"") && !pkName.endsWith("\"")) {
            pkName = this.getColumnKeyStr(fieldsByDatabaseName, con, insert.getDb(), insert.getTable(), pkName);
            insert.setPkName(pkName);
        }
        if (StringUtils.isBlank((String)insertType) || "error".equalsIgnoreCase(insertType)) {
            return this.getInsertErrorTypeSql(sqlSb, insert, con);
        }
        Map insertColumns = insert.getInsertColumns();
        if (!insertColumns.containsKey(insert.getPkName())) {
            return this.getInsertErrorTypeSql(sqlSb, insert, con);
        }
        HashMap newSortInsertColumns = new HashMap();
        newSortInsertColumns.put(insert.getPkName(), insertColumns.get(insert.getPkName()));
        insertColumns.remove(insert.getPkName());
        newSortInsertColumns.putAll(insertColumns);
        insert.setInsertColumns(newSortInsertColumns);
        HashMap noPKColumns = new HashMap(insertColumns);
        StringBuilder paramsStr = new StringBuilder();
        for (Map.Entry aMap : newSortInsertColumns.entrySet()) {
            paramsStr.append((String)aMap.getKey()).append(",");
        }
        paramsStr.delete(paramsStr.length() - 1, paramsStr.length());
        sqlSb.append("merge into ");
        this.initAppendTableSql(sqlSb, insert.getTable(), con);
        sqlSb.append(" a using (");
        sqlSb.append("select ").append((CharSequence)paramsStr).append(" FROM (");
        if (!insert.isBatch()) {
            sqlSb.append("SELECT");
            for (Map.Entry aMap : newSortInsertColumns.entrySet()) {
                sqlSb.append(" ? AS ").append((String)aMap.getKey()).append(",");
            }
            sqlSb.delete(sqlSb.length() - 1, sqlSb.length());
        } else {
            for (int i = 0; i < insert.getInsertColumnsBatch().size(); ++i) {
                sqlSb.append("SELECT");
                for (Map.Entry entry : newSortInsertColumns.entrySet()) {
                    sqlSb.append(" ? AS ").append((String)entry.getKey()).append(",");
                }
                sqlSb.delete(sqlSb.length() - 1, sqlSb.length());
                sqlSb.append(" UNION ALL ");
            }
            sqlSb.delete(sqlSb.length() - 11, sqlSb.length());
        }
        sqlSb.append(") tmp ) b on ( a.").append(insert.getPkName()).append(" = b.").append(insert.getPkName()).append(")");
        if ("replace".equalsIgnoreCase(insertType)) {
            sqlSb.append(" WHEN MATCHED THEN UPDATE SET ");
            for (Map.Entry aMap : noPKColumns.entrySet()) {
                sqlSb.append("a.").append((String)aMap.getKey()).append(" = b.").append((String)aMap.getKey()).append(",");
            }
            sqlSb.delete(sqlSb.length() - 1, sqlSb.length());
        }
        sqlSb.append(" WHEN NOT MATCHED THEN INSERT (").append((CharSequence)paramsStr).append(") VALUES (").append((CharSequence)paramsStr).append(")");
        return sqlSb;
    }

    private StringBuilder getInsertErrorTypeSql(StringBuilder sqlSb, DBInsert insert, Connection con) {
        StringBuilder paramSb = new StringBuilder();
        sqlSb.append("insert");
        paramSb.append(" into ");
        this.initAppendTableSql(paramSb, insert.getTable(), con);
        paramSb.append(" (");
        Map insertColumns = insert.getInsertColumns();
        if (insertColumns == null) {
            List list = insert.getInsertColumnsBatch();
            insertColumns = (Map)list.get(0);
        }
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry aMap : insertColumns.entrySet()) {
            Object value;
            if (!insert.isBatch() && (value = aMap.getValue()) == null) continue;
            paramSb.append((String)aMap.getKey()).append(StrSplit.D);
            valueSb.append("?,");
        }
        String params = paramSb.substring(0, paramSb.length() - 1);
        String value = valueSb.substring(0, valueSb.length() - 1);
        StringBuilder paramAndValueSb = new StringBuilder(params);
        paramAndValueSb.append(") values ");
        valueSb = new StringBuilder();
        valueSb.append("(").append(value).append("),");
        if (insert.isBatch()) {
            String valuesSql = valueSb.toString();
            List insertBatchColumns = insert.getInsertColumnsBatch();
            for (int i = 1; i < insertBatchColumns.size(); ++i) {
                valueSb.append(valuesSql);
            }
        }
        paramAndValueSb.append(valueSb.substring(0, valueSb.length() - 1));
        sqlSb.append((CharSequence)paramAndValueSb);
        return sqlSb;
    }

    public void handleInsertResult(DBInsert insert, Connection con, PreparedStatement ps, JSONObject result, int insertNum) {
        String pkName;
        block13: {
            pkName = insert.getPkName();
            if (!insert.isBatch()) {
                try {
                    if (StringUtil.isNotBlank((String)pkName)) {
                        Map insertColumns = insert.getInsertColumns();
                        if (insertColumns != null && insertColumns.containsKey(insert.getPkName()) && insertColumns.get(insert.getPkName()) != null) {
                            result.put("pkNum", insertColumns.get(pkName));
                            break block13;
                        }
                        ResultSet rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            Object pkNum = rs.getObject(1);
                            result.put("pkNum", pkNum);
                        } else if (insertColumns != null) {
                            result.put("pkNum", insertColumns.get(pkName));
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            break block13;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        break block13;
                    }
                    result.put("count", (Object)insertNum);
                }
                catch (Throwable e) {
                    log.error("[DBWriteBase.insert]_exception", e);
                }
            } else {
                result.put("count", (Object)insertNum);
            }
        }
        if (StringUtil.isNotBlank((String)pkName) && pkName.startsWith("\"") && pkName.endsWith("\"")) {
            pkName = pkName.substring(1, pkName.length() - 1);
            insert.setPkName(pkName);
        }
    }

    public StringBuilder initInSql(StringBuilder sqlSB, DBQuery dbQuery) {
        List inList = dbQuery.getIn();
        if (inList == null || inList.size() == 0) {
            return sqlSB;
        }
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), dbQuery.getTable());
        StringBuilder inCondition = new StringBuilder();
        for (In in : inList) {
            if (in == null) {
                return sqlSB;
            }
            List list = in.getValue();
            String key = in.getKey();
            boolean filterEmptyInValue = in.isFilterEmptyValue();
            if (StringUtil.isBlank((String)key)) {
                return sqlSB;
            }
            if (CollectionUtil.isEmpty((Collection)list) && filterEmptyInValue) continue;
            key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbQuery.getDb(), dbQuery.getTable(), key);
            inCondition.append(key);
            inCondition.append(" in (");
            for (Object value : list) {
                if (value == null) continue;
                inCondition.append("?,");
            }
            String str = inCondition.substring(0, inCondition.toString().endsWith(",") ? inCondition.length() - 1 : inCondition.length());
            inCondition = new StringBuilder(str);
            inCondition.append(") and ");
        }
        if (!"".equals(inCondition) && inCondition.toString().endsWith(" and ")) {
            if (sqlSB.indexOf("where") == -1) {
                sqlSB.append(" where ");
            } else {
                sqlSB.append(" and ");
            }
            StringBuilder result = new StringBuilder(inCondition.substring(0, inCondition.length() - 5));
            return sqlSB.append((CharSequence)result);
        }
        return sqlSB;
    }

    public Map<String, Object> initParamsSql(Map<String, Object> queryParams, String dbName, String tableName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbName, tableName);
        for (Map.Entry<String, Object> param : queryParams.entrySet()) {
            if (NumberUtils.isNumber((String)param.getKey())) {
                result.put(param.getKey(), param.getValue());
                continue;
            }
            String key = param.getKey().trim();
            key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbName, tableName, key);
            result.put(key, param.getValue());
        }
        return result;
    }

    public List<Map<String, Object>> initListParamsSql(List<Map<String, Object>> listParams, String dbName, String tableName) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbName, tableName);
        for (Map<String, Object> listParam : listParams) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (Map.Entry<String, Object> param : listParam.entrySet()) {
                if (NumberUtils.isNumber((String)param.getKey())) {
                    params.put(param.getKey(), param.getValue());
                    continue;
                }
                String key = param.getKey().trim();
                key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbName, tableName, key);
                params.put(key, param.getValue());
            }
            result.add(params);
        }
        return result;
    }

    public JSONArray initInSql(JSONArray jsonArray, String dbName, String tableName) {
        JSONArray result = new JSONArray();
        List<String> fieldsByDatabaseName = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbName, tableName);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject in = jsonArray.getJSONObject(i);
            String key = in.getString("key");
            key = this.getColumnKeyStr(fieldsByDatabaseName, null, dbName, tableName, key);
            in.put("key", (Object)key);
            result.add((Object)in);
        }
        return result;
    }

    public ResultSet cascadeQuery(DBQuery dbQuery, Connection con, PreparedStatement ps, JSON data, JSONObject cascadeConf) throws SQLException {
        String table = cascadeConf.getString("table");
        String tableStr = this.getTableStr(con, dbQuery.getDb(), table);
        if (StringUtil.isBlank((String)table)) {
            throw new SQLException("\u7ea7\u8054\u67e5\u8be2\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cascadeKey = cascadeConf.getString("cascadeKey");
        cascadeKey = this.getCascadeKey(dbQuery, cascadeKey);
        StringBuilder cascadeKeyParams = new StringBuilder();
        if (data instanceof List || data instanceof JSONArray) {
            List list = (List)data;
            for (Object dataObj : list) {
                Map dataMap = (Map)dataObj;
                Object cascadeKeyObj = dataMap.get(cascadeKey);
                if (cascadeKeyObj == null || "".equals(cascadeKeyObj)) continue;
                cascadeKeyParams.append("'").append(cascadeKeyObj).append("'").append(StrSplit.D);
            }
        } else {
            Map dataMap = (Map)data;
            Object cascadeKeyObj = dataMap.get(cascadeKey);
            if (cascadeKeyObj != null && !"".equals(cascadeKeyObj)) {
                cascadeKeyParams.append(cascadeKeyObj).append(StrSplit.D);
            }
        }
        if (StringUtil.isBlank((String)cascadeKeyParams.toString())) {
            throw new SQLException("\u7ea7\u8054\u67e5\u8be2\u8868key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cascadeKeySql = cascadeKeyParams.substring(0, cascadeKeyParams.length() - 1);
        String beCascadeedKey = cascadeConf.getString("beCascadeedKey");
        List<String> beCascadeFields = this.damengTableFieldsInfo.getFieldsByDatabaseName(dbQuery.getDb(), table);
        beCascadeedKey = this.getColumnKeyStr(beCascadeFields, null, dbQuery.getDb(), table, beCascadeedKey);
        StringBuilder cascadeKeyStr = new StringBuilder(beCascadeedKey);
        String columns = cascadeConf.getString("columns");
        StringBuilder sql = new StringBuilder("select ");
        if (StringUtil.isBlank((String)columns)) {
            columns = "*";
        }
        sql.append(columns).append(StrSplit.D).append((CharSequence)cascadeKeyStr).append(" from ").append(tableStr).append(" where ");
        cascadeKeyStr.append(StrSplit.KG).append("in").append(StrSplit.KG).append("(");
        sql.append((CharSequence)cascadeKeyStr).append(cascadeKeySql).append(")");
        JSONObject cascadeQueryParams = cascadeConf.getJSONObject("queryParams");
        if (MapUtils.isNotEmpty((Map)cascadeQueryParams)) {
            StringBuilder rightTableSelectSb = new StringBuilder("and (");
            String joinCondition = cascadeQueryParams.getString("condition");
            if (StringUtil.isNotEmpty((CharSequence)joinCondition)) {
                rightTableSelectSb.append(joinCondition).append(" and ");
                cascadeQueryParams.remove((Object)"condition");
            }
            for (Map.Entry aMap : cascadeQueryParams.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                String key = (String)aMap.getKey();
                key = this.getColumnKeyStr(beCascadeFields, con, dbQuery.getDb(), table, key);
                rightTableSelectSb.append(key).append("=?").append(" and ");
            }
            if (rightTableSelectSb.substring(rightTableSelectSb.length() - 5).equals(" and ")) {
                rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 5));
            }
            if (rightTableSelectSb.substring(rightTableSelectSb.length() - 7).equals(" where ")) {
                rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 7));
            }
            rightTableSelectSb.append(")");
            sql.append((CharSequence)rightTableSelectSb);
        }
        ps = con.prepareStatement(sql.toString());
        this.initCascadeParam(sql, dbQuery, ps);
        log.info(" sql : {}", (Object)sql.toString());
        return ps.executeQuery();
    }

    private String getCascadeKey(DBQuery dbQuery, String cascadeKey) {
        Boolean camelCase;
        String upperOrLowerCase = dbQuery.getUpperOrLowerCase();
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "upperCase".equals(upperOrLowerCase)) {
            cascadeKey = cascadeKey.toUpperCase();
        }
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "lowerCase".equals(upperOrLowerCase)) {
            cascadeKey = cascadeKey.toLowerCase();
        }
        if ((camelCase = dbQuery.getCamelCase()).booleanValue() && cascadeKey.indexOf("_") != -1) {
            cascadeKey = this.camelCase(cascadeKey.toLowerCase());
            return cascadeKey;
        }
        return cascadeKey;
    }

    public String camelCase(String columnName) {
        String[] arr = columnName.split("_");
        if (arr.length > 1) {
            StringBuilder columnNameSb = new StringBuilder(arr[0]);
            for (int index = 1; index < arr.length; ++index) {
                String firstChar = arr[index].charAt(0) + "";
                columnNameSb.append(firstChar.toUpperCase() + arr[index].substring(1));
            }
            columnName = columnNameSb.toString();
        }
        return columnName;
    }

    private String getColumnKeyStr(List<String> fieldsByDatabaseName, Connection con, String dbName, String tableName, String key) {
        key = key.trim();
        if (fieldsByDatabaseName == null) {
            return key;
        }
        if (fieldsByDatabaseName.contains(key)) {
            return "\"" + key + "\"";
        }
        List<String> list = DamengTableFieldsInfo.refreshTableInfo(con, dbName, tableName, null);
        if (list != null && list.contains(key)) {
            return "\"" + key + "\"";
        }
        return key;
    }

    private String getTableStr(Connection con, String db, String table) {
        List<String> tableList = this.damengTableFieldsInfo.getFieldsByDatabaseName(db, table);
        if (tableList != null) {
            table = "\"" + table + "\"";
        } else {
            List<String> list = DamengTableFieldsInfo.refreshTableInfo(con, db, table, null);
            if (list != null) {
                table = "\"" + table + "\"";
            }
        }
        return table;
    }

    private String getSchema(Connection con) {
        String schema = MetaUtil.getSchema((Connection)con);
        if (schema == null) {
            throw new RuntimeException();
        }
        return schema;
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas((Connection)conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema((Connection)conn, null, (String)schema, (String)tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable((Connection)conn, null, (String)schema, (String)tableName);
    }
}

