/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sqlserver.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.Page;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sqlserver")
public class SqlserverDBHandle
extends DBHandle {
    private static final Logger log = LoggerFactory.getLogger(SqlserverDBHandle.class);

    public String getName() {
        return "microsoft sql server";
    }

    public StringBuilder initInsertConditionSql(DBInsert insert, Connection con) throws SQLException {
        StringBuilder paramSb = new StringBuilder();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("insert");
        paramSb.append(" into ").append(insert.getTable()).append(" (");
        Map insertColumns = insert.getInsertColumns();
        if (insertColumns == null) {
            List list = insert.getInsertColumnsBatch();
            insertColumns = (Map)list.get(0);
        }
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry aMap : insertColumns.entrySet()) {
            Object value;
            if (!insert.isBatch() && (value = aMap.getValue()) == null) continue;
            paramSb.append((String)aMap.getKey()).append(StrSplit.D);
            valueSb.append("?,");
        }
        String params = paramSb.substring(0, paramSb.length() - 1);
        String value = valueSb.substring(0, valueSb.length() - 1);
        StringBuilder paramAndValueSb = new StringBuilder(params);
        paramAndValueSb.append(") values ");
        valueSb = new StringBuilder();
        valueSb.append("(").append(value).append("),");
        if (insert.isBatch()) {
            String valuesSql = valueSb.toString();
            List insertBatchColumns = insert.getInsertColumnsBatch();
            for (int i = 1; i < insertBatchColumns.size(); ++i) {
                valueSb.append(valuesSql);
            }
        }
        paramAndValueSb.append(valueSb.substring(0, valueSb.length() - 1));
        sqlSb.append((CharSequence)paramAndValueSb);
        return sqlSb;
    }

    public StringBuilder initSelectOneLimitSql(StringBuilder sqlSB, DBQuery dbQuery) {
        if (dbQuery.getSelectOne().booleanValue()) {
            sqlSB = new StringBuilder(sqlSB.toString().replaceFirst("select ", "select top 1 "));
        }
        return sqlSB;
    }

    public StringBuilder initSchemaSql(Connection con, StringBuilder sqlSb, String schema) {
        sqlSb.append("SELECT DISTINCT schemaname AS table_schema FROM pg_tables WHERE tablename NOT LIKE'pg%' AND tablename NOT LIKE'sql_%' ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND schemaname LIKE ").append("'%").append(schema).append("%'");
        }
        return sqlSb;
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) {
        sqlSb.append("SELECT b.table_name, a.name as column_name FROM SysColumns a RIGHT JOIN (SELECT TOP 10 t1.name as table_name, t1.id FROM SysObjects t1 ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("join sys.schemas t2 on t2.principal_id = t1.uid and t2.name = '").append(schema).append("' ");
        }
        sqlSb.append("WHERE t1.XType='U' ");
        if (StringUtil.isNotBlank((String)table)) {
            sqlSb.append(" t1.AND name LIKE ").append("'%").append(table).append("%'");
        }
        sqlSb.append(") b ON a.id = b.id ");
        sqlSb.append("order by a.colid");
        return sqlSb;
    }

    public void handleInsertResult(DBInsert insert, Connection con, PreparedStatement ps, JSONObject result, int insertNum) {
        result.put("count", (Object)insertNum);
    }

    public StringBuilder initPageSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Page page = dbQuery.getPage();
        if (page == null) {
            return sqlSB;
        }
        Integer pageNum = page.getPageNum();
        Integer pageSize = page.getPageSize();
        String pageOrderColumns = page.getPageOrderColumns();
        String pageType = page.getPageType();
        if (pageNum != null && pageSize != null) {
            if (pageType.equals("row_number")) {
                String s = sqlSB.toString().replaceFirst("select ", "select row_number() over(ORDER BY " + pageOrderColumns + ") as rownumber, ");
                StringBuilder newSqlSB = new StringBuilder();
                newSqlSB.append("select top ").append(pageSize).append(" * from (").append(s).append(") temp_row where rownumber >").append((pageNum - 1) * pageSize);
                return newSqlSB;
            }
            if (pageType.equals("offset /fetch next")) {
                sqlSB.append(" order by ").append(pageOrderColumns).append(" offset ").append((pageNum - 1) * pageSize).append(" rows fetch next ").append(pageSize).append(" rows only");
                return sqlSB;
            }
        }
        return sqlSB;
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas((Connection)conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema((Connection)conn, null, (String)schema, (String)tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable((Connection)conn, null, (String)schema, (String)tableName);
    }
}

