/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.manager.SpringContextManager;
import com.manatee.quartz.QuartzJobService;
import com.manatee.quartz.domain.QuartzJob;
import com.manatee.quartz.util.CronUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;

public abstract class AbstractCallbackQuartzJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractCallbackQuartzJob.class);
    private static ThreadLocal<Date> threadLocal = new ThreadLocal();
    private DBReadUtil dbReadUtil = (DBReadUtil)SpringContextManager.getBean(DBReadUtil.class);
    private QuartzJobService quartzJobService = (QuartzJobService)SpringContextManager.getBean(QuartzJobService.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String traceId = System.currentTimeMillis() + "";
        MDC.put((String)"traceId", (String)traceId);
        QuartzJob quartzJob = new QuartzJob();
        try {
            BeanUtils.copyProperties((Object)context.getMergedJobDataMap().get((Object)"TASK_PROPERTIES"), (Object)quartzJob);
            boolean isExecute = this.before(context, quartzJob);
            if (!isExecute) {
                return;
            }
            if (quartzJob != null) {
                this.doExecute(context, quartzJob);
            }
            this.after(context, quartzJob, null);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38  - \uff1a", (Throwable)e);
            this.after(context, quartzJob, e);
        }
    }

    protected boolean before(JobExecutionContext context, QuartzJob quartzJob) {
        QuartzJob quartzJobNew = this.getQuartzJob(quartzJob.getId());
        if (quartzJobNew == null) {
            return false;
        }
        Integer callbackNum = quartzJobNew.getCallbackNum();
        if (callbackNum == null) {
            callbackNum = 0;
        }
        if (this.updateQuartzJobCallbackNum(quartzJobNew, callbackNum + 1) != 1) {
            log.info("\u56de\u8c03\u4efb\u52a1\u88ab\u96c6\u7fa4\u4e2d\u5176\u5b83\u8282\u70b9\u62a2\u5148\u6267\u884c\u3010{}\u3011", (Object)quartzJobNew.getJobName());
            return false;
        }
        return true;
    }

    protected void after(JobExecutionContext context, QuartzJob quartzJob, Exception e) {
        String callbackStatus;
        Map resultMap;
        boolean isCallback = false;
        ModularityResult modularityResult = (ModularityResult)context.getResult();
        if (modularityResult != null && modularityResult.isSuccess() && (resultMap = modularityResult.getData()).containsKey("callbackStatus") && StringUtils.equals((CharSequence)(callbackStatus = (String)resultMap.get("callbackStatus")), (CharSequence)"SUCCESS")) {
            isCallback = true;
        }
        QuartzJob quartzJobNew = this.getQuartzJob(quartzJob.getId());
        if (isCallback) {
            this.updateQuartzJobCallbackNum(quartzJobNew, 0);
            this.quartzJobService.deleteCallbackJob(quartzJobNew);
        } else {
            Integer callbackNum = quartzJobNew.getCallbackNum();
            if (callbackNum == null) {
                callbackNum = 1;
            }
            if (callbackNum >= 5) {
                this.updateQuartzJobCallbackNum(quartzJobNew, 0);
                this.quartzJobService.deleteCallbackJob(quartzJobNew);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.quartzJobService.getDatasourceTime());
            calendar.add(13, 30 * callbackNum);
            quartzJobNew.setCallbackNum(callbackNum + 1);
            this.quartzJobService.modifyCallbackJobTime(quartzJobNew, CronUtils.getCron(calendar.getTime()));
        }
    }

    protected abstract void doExecute(JobExecutionContext var1, QuartzJob var2) throws Exception;

    private QuartzJob getQuartzJob(Long id) {
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String valid = "valid";
        String pk = "id";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            valid = "VALID";
            pk = "ID";
        }
        try {
            DBQuery quartzJobDbQuery = new DBQuery();
            quartzJobDbQuery.setDatabaseProductName(defaultDatabaseProductName);
            quartzJobDbQuery.setTable(lowcodeQuartzJob);
            quartzJobDbQuery.setCamelCase(Boolean.valueOf(true));
            quartzJobDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
            moduleConditionMap.put(valid, 0);
            moduleConditionMap.put(pk, id);
            quartzJobDbQuery.setConditionMap(moduleConditionMap);
            quartzJobDbQuery.setDb("hainiu_lowcode");
            JSONArray quartzJobArr = (JSONArray)this.dbReadUtil.find(quartzJobDbQuery);
            if (quartzJobArr != null && quartzJobArr.size() > 0) {
                List quartzJobList = quartzJobArr.toJavaList(QuartzJob.class);
                return (QuartzJob)quartzJobList.get(0);
            }
        }
        catch (Throwable e) {
            log.error("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff1a", e);
        }
        return null;
    }

    private int updateQuartzJobCallbackNum(QuartzJob job, Integer callbackNum) {
        if (null == job) {
            return 0;
        }
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String pk = "id";
        String callbackNumkey = "callback_num";
        String defaultDatabaseProductName = this.quartzJobService.getDefaultDatabaseProductName();
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            pk = "ID";
            callbackNumkey = "CALLBACK_NUM";
        }
        try {
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)"");
            String dataBaseName = dataSource.getDataBaseName();
            ArrayList<JSONObject> whereListParams = new ArrayList<JSONObject>();
            JSONObject whereJson1 = new JSONObject();
            whereJson1.put("fieldName", (Object)pk);
            whereJson1.put("symbol", (Object)"=");
            whereJson1.put("condition", (Object)"and");
            whereJson1.put("fieldValue", (Object)job.getId());
            whereListParams.add(whereJson1);
            if (callbackNum != null && callbackNum > 0) {
                JSONObject whereJson2 = new JSONObject();
                whereJson2.put("fieldName", (Object)callbackNumkey);
                whereJson2.put("fieldValue", (Object)job.getCallbackNum());
                whereJson2.put("symbol", (Object)"=");
                whereJson2.put("condition", (Object)"and");
                whereListParams.add(whereJson2);
            }
            DbEntity whereDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setWhereConditionListForDbQuery(lowcodeQuartzJob, whereListParams);
            ArrayList<JSONObject> updateListParams = new ArrayList<JSONObject>();
            JSONObject updateJson1 = new JSONObject();
            updateJson1.put("fieldName", (Object)callbackNumkey);
            updateJson1.put("fieldValue", (Object)callbackNum);
            updateListParams.add(updateJson1);
            DbEntity updateDbEntity = DbEntity.create((String)(dataBaseName + '.' + lowcodeQuartzJob)).setInsertConditionList(updateListParams);
            int updateCount = DbClient.use((String)"").update(updateDbEntity, whereDbEntity);
            return updateCount;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u56de\u8c03\u6b21\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            return 0;
        }
    }
}

