/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.common.util.SerializeUtil;
import com.manatee.redis.util.RedisSentinelClientInit;
import com.manatee.redis.util.RedisSentinelReadUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service
public class RedisSentinelWriteUtil {
    private final Logger log = LoggerFactory.getLogger(RedisSentinelWriteUtil.class);
    @Resource
    private RedisSentinelClientInit redisSentinelClientInit;
    @Resource
    private RedisSentinelReadUtil redisSentinelReadUtil;

    public int setValue(String key, String json) {
        return this.setValue(0, key, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setValue(int db, String key, String json) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.set(key, json);
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incr(int db, String key) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        int ret = 0;
        if (jedis != null) {
            try {
                long l = jedis.incr(key);
                return l;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    public int setex(String key, String value, int seconds) {
        return this.setex(0, key, value, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setex(int db, String key, String value, int seconds) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.setex(key, seconds, value);
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hdelValue(int db, String key, String ... field) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                jedis.select(db);
                ret = jedis.hdel(key, field);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hsetValue(int db, String key, String field, String value) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                jedis.select(db);
                ret = jedis.hset(key, field, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmsetValue(int db, String key, Map<String, String> fields) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        String ret = "";
        if (jedis != null) {
            try {
                jedis.select(db);
                ret = jedis.hmset(key, fields);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    private List<String> hmgetValue(Jedis jedis, int db, String objectName, String ... fields) {
        List values = null;
        if (jedis != null) {
            jedis.select(db);
            values = jedis.hmget(objectName, fields);
        }
        return values;
    }

    private Map<String, String> hmgetAll(Jedis jedis, int db, String objectName) {
        Map valueMap = null;
        if (jedis != null) {
            jedis.select(db);
            valueMap = jedis.hgetAll(objectName);
        }
        return valueMap;
    }

    private Map<String, Object> list2LinkedMap(String[] fields, List<String> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            String value = values.get(i);
            if (value == null) continue;
            result.put(fieldName, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delValue(int db, String key) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                jedis.select(db);
                ret = jedis.del(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delValue(int db, String[] keys) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                jedis.select(db);
                ret = jedis.del(keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delKeys(int db, String pattern) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                jedis.select(db);
                int count = 1000;
                List<String> setkeys = this.redisSentinelReadUtil.scan(jedis, pattern, count);
                if (!setkeys.isEmpty()) {
                    String[] keys = setkeys.toArray(new String[setkeys.size()]);
                    jedis.del(keys);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setValue(byte[] key, Object obj) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.set(key, SerializeUtil.serialize((Object)obj));
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delValue(byte[] key) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.del(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lpushList(String key, String json) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, new String[]{json});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lpushList(int db, String key, String[] values) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rpushList(String key, String json) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.rpush(key, new String[]{json});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lpushList(String key, String[] values) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rpushList(String key, String[] values) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.rpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return ret;
    }

    private static void putResult(String key, Map<String, String> resultMap, List<Map.Entry<String, String>> entryList) {
        for (Map.Entry<String, String> entry : entryList) {
            String entryKey = entry.getKey();
            String entryValue = entry.getValue();
            resultMap.put(entryKey, entryValue);
        }
        resultMap.put("keyCount", entryList.size() + "");
        if (key.contains(":")) {
            String primaryKey = key.substring(key.lastIndexOf(":"));
            resultMap.put("primaryKey", primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sadd(int db, String key, String ... members) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.sadd(key, members);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zadd(int db, String key, double score, String member) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zadd(key, score, member);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zadd(int db, String key, Map<String, Double> scoreMembers) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zadd(key, scoreMembers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double zincrby(int db, String key, double score, String member) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        double result = 0.0;
        if (jedis != null) {
            try {
                result = jedis.zincrby(key, score, member);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long expire(int db, String key, int seconds) {
        Jedis jedis = this.redisSentinelClientInit.getWritePoolInstance();
        jedis.select(db);
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.expire(key, seconds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.redisSentinelClientInit.returnRes(jedis);
            }
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

