/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.domain.DtHashDO;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisKeyValueAddProcess
implements IProcess {
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;
    private Logger log = LoggerFactory.getLogger(RedisKeyValueAddProcess.class);

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key", "paramsKey"});
        this.addToRedis(content, conf);
    }

    protected void addToRedis(ProcessContent content, JSONObject conf) throws BizException {
        DtHashDO dtHashDO = this.getDtHashDO(content, conf);
        if (dtHashDO == null) {
            this.log.error("[AddStrValueToRedisProcess.process]_biz_occur,code:{},msg:{}", content.getRequest("lowcodeModule"), (Object)"param_is_error");
            throw new BizException(ResultCode.PARAM_IS_ERROR, "param_is_error");
        }
        this.dtSourceManager.addStringToRedis(dtHashDO);
    }

    private DtHashDO getDtHashDO(ProcessContent content, JSONObject conf) {
        String addKey = this.variableUtil.calVarInConf(content, "key");
        int db = RedisDbUtil.getRedisDB(content);
        String value = this.variableUtil.calVarInConf(content, "paramsKey");
        DtHashDO dtHashDO = new DtHashDO();
        dtHashDO.setDbIndex(db);
        dtHashDO.setKey(addKey);
        if (value == null) {
            return null;
        }
        if (conf.containsKey((Object)"isStaticRedis")) {
            dtHashDO.setStaticRedis(conf.getBoolean("isStaticRedis"));
        }
        dtHashDO.setValue(value);
        String expTimeStr = this.variableUtil.calVarInConf(content, "expTime");
        if (expTimeStr != null) {
            Integer expTime = Integer.valueOf(expTimeStr);
            dtHashDO.setExpTime(expTime);
        }
        return dtHashDO;
    }

    private String convertValue(Object fieldV) {
        String valueStr = fieldV instanceof Map || fieldV instanceof List ? JSON.toJSONString((Object)fieldV) : String.valueOf(fieldV);
        return valueStr;
    }

    public String getName() {
        return "redisKeyValueAdd";
    }
}

