/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.postgresql.handle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.In;
import com.manatee.common.domain.Page;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="postgresql")
public class PostgreSqlDBHandle
extends DBHandle {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlDBHandle.class);

    public String getName() {
        return "postgresql";
    }

    public StringBuilder initAppendTableSql(StringBuilder sqlSB, String table, Connection con) {
        if (table.contains(" ")) {
            String[] tables = table.split(" ");
            sqlSB.append("\"").append(tables[0]).append("\"");
            for (int i = 1; i < tables.length; ++i) {
                sqlSB.append(" ").append(tables[i]);
            }
        } else {
            sqlSB.append("\"").append(table).append("\"");
        }
        return sqlSB;
    }

    public void handleInsertResult(DBInsert insert, Connection con, PreparedStatement ps, JSONObject result, int insertNum) {
        block11: {
            if (!insert.isBatch()) {
                try {
                    String pkName = insert.getPkName();
                    if (StringUtil.isNotBlank((String)pkName)) {
                        ResultSet rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            Object pkNum = rs.getObject(insert.getPkName());
                            result.put("pkNum", pkNum);
                        } else {
                            Map insertColumns = insert.getInsertColumns();
                            if (insertColumns != null) {
                                result.put("pkNum", insertColumns.get(pkName));
                            }
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            break block11;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                    result.put("count", (Object)insertNum);
                }
                catch (Throwable e) {
                    log.error("[DBWriteBase.insert]_exception", e);
                }
            } else {
                result.put("count", (Object)insertNum);
            }
        }
    }

    public StringBuilder initJoinSql(StringBuilder sqlSB, DBQuery dbQuery, Connection con) {
        int i;
        if (CollectionUtil.isEmpty((Collection)dbQuery.getJoin())) {
            return sqlSB;
        }
        sqlSB = new StringBuilder("select ");
        String tableAlias = dbQuery.getTable();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String[] fields;
            for (String field : fields = dbQuery.getColumns().split(",")) {
                if ("*".equals(field = field.trim())) continue;
                if (field.startsWith("\"") && field.endsWith("\"")) {
                    field = field.substring(1, field.length() - 1);
                }
                fieldNameList.add(tableAlias + ".\"" + field + "\"");
            }
        } else {
            fieldNameList.add(tableAlias + ".*");
        }
        JSONArray joinArray = dbQuery.getJoin();
        StringBuilder joinSb = new StringBuilder();
        if (joinArray != null) {
            for (i = 0; i < joinArray.size(); ++i) {
                String[] rightTableFields;
                JSONObject joinQueryParams;
                JSONObject joinConf = joinArray.getJSONObject(i);
                StringBuilder rightTableSelectSb = new StringBuilder(joinConf.getString("table"));
                String rightTable = joinConf.getString("table");
                String rightTableUnquoted = rightTable.trim();
                if (rightTableUnquoted.startsWith("\"") && rightTableUnquoted.endsWith("\"")) {
                    rightTableUnquoted = rightTableUnquoted.substring(1, rightTableUnquoted.length() - 1);
                }
                if (MapUtil.isNotEmpty((Map)(joinQueryParams = joinConf.getJSONObject("queryParams")))) {
                    rightTableSelectSb = new StringBuilder("(select * from " + rightTable + " where ");
                    String joinCondition = joinQueryParams.getString("condition");
                    if (StrUtil.isNotEmpty((CharSequence)joinCondition)) {
                        rightTableSelectSb.append(joinCondition).append(" and ");
                        joinQueryParams.remove((Object)"condition");
                    }
                    for (Map.Entry aMap : joinQueryParams.entrySet()) {
                        Object value = aMap.getValue();
                        if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                        rightTableSelectSb.append("\"").append((String)aMap.getKey()).append("\"=?").append(" and ");
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 5).equals(" and ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 5));
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 7).equals(" where ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 7));
                    }
                    rightTableSelectSb.append(")");
                }
                String joinKey = joinConf.getString("joinKey");
                String beJoinedKey = joinConf.getString("beJoinedKey");
                String joinType = joinConf.getString("joinType");
                if (StrUtil.isNotEmpty((CharSequence)joinType)) {
                    joinSb.append(" " + joinType + " ");
                } else {
                    joinSb.append(" JOIN ");
                }
                joinSb.append((CharSequence)rightTableSelectSb).append(" ").append(rightTable).append(" ON ").append(tableAlias).append(".").append(joinKey).append(" = ").append(rightTable).append(".").append(beJoinedKey);
                String rightTableColumns = joinConf.getString("columns");
                if (!StrUtil.isNotEmpty((CharSequence)rightTableColumns)) continue;
                for (String rightTableField : rightTableFields = rightTableColumns.split(",")) {
                    String rightTableFieldName;
                    String[] rtfnArr = rightTableField.trim().split(" ");
                    if (rtfnArr.length <= 1) {
                        rightTableFieldName = rightTableUnquoted + "_";
                        rightTableFieldName = rightTableField.startsWith("\"") && rightTableField.endsWith("\"") ? rightTableFieldName + rightTableField.substring(1, rightTableField.length() - 1) + "_" : rightTableFieldName + rightTableField;
                    } else {
                        rightTableFieldName = rightTableField.replaceFirst(rtfnArr[0], "");
                    }
                    fieldNameList.add(rightTable + "." + rtfnArr[0] + " " + rightTableFieldName);
                }
            }
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            sqlSB = sqlSB.append((String)fieldNameList.get(i));
            if (i >= fieldNameList.size() - 1) continue;
            sqlSB = sqlSB.append(",");
        }
        sqlSB.append(" from \"" + dbQuery.getTable()).append("\" ").append(tableAlias);
        sqlSB.append((CharSequence)joinSb);
        this.handleFieldPrefixForJoin(dbQuery);
        return sqlSB;
    }

    public StringBuilder initConditionMapSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Map conditionMap = dbQuery.getConditionMap();
        if (conditionMap != null && conditionMap.size() != 0) {
            sqlSB.append(" where ");
            for (Map.Entry aMap : conditionMap.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                if (dbQuery.getJoin() != null) {
                    String[] keys = ((String)aMap.getKey()).split("\\.");
                    sqlSB.append(keys[0]).append(".").append(keys[1]).append("=?").append(" and ");
                    continue;
                }
                sqlSB.append((String)aMap.getKey()).append("=?").append(" and ");
            }
            if (sqlSB.substring(sqlSB.length() - 5).equals(" and ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 5));
            }
            if (sqlSB.substring(sqlSB.length() - 7).equals(" where ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 7));
            }
        }
        return sqlSB;
    }

    public StringBuilder initInSql(StringBuilder sqlSB, DBQuery dbQuery) {
        List inList = dbQuery.getIn();
        if (inList == null || inList.size() == 0) {
            return sqlSB;
        }
        StringBuilder inCondition = new StringBuilder();
        for (In in : inList) {
            if (in == null) {
                return sqlSB;
            }
            List list = in.getValue();
            String key = in.getKey();
            boolean filterEmptyInValue = in.isFilterEmptyValue();
            if (StringUtil.isBlank((String)key)) {
                return sqlSB;
            }
            if (CollectionUtil.isEmpty((Collection)list) && !filterEmptyInValue) {
                return sqlSB.append(" ").append(key).append(" in ()");
            }
            if (dbQuery.getJoin() != null) {
                String[] inKeys = key.split("\\.");
                inCondition.append(inKeys[0]).append(".\"").append(inKeys[1]).append("\"");
            } else {
                inCondition.append("\"").append(key).append("\"");
            }
            inCondition.append(" in (");
            for (Object value : list) {
                if (value == null) continue;
                inCondition.append("?,");
            }
            String str = inCondition.substring(0, inCondition.length() - 1);
            inCondition = new StringBuilder(str);
            inCondition.append(") and ");
        }
        if (!"".contentEquals(inCondition) && inCondition.toString().endsWith(" and ")) {
            if (sqlSB.indexOf("where") == -1) {
                sqlSB.append(" where ");
            } else {
                sqlSB.append(" and ");
            }
            return sqlSB.append(inCondition.substring(0, inCondition.length() - 5));
        }
        return sqlSB;
    }

    public StringBuilder initSortSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Map sortMap = dbQuery.getSort();
        if (sortMap != null && sortMap.size() > 0) {
            sqlSB.append(" order by ");
            for (String sortKey : sortMap.keySet()) {
                if (dbQuery.getJoin() != null) {
                    String[] sortKeys = sortKey.split("\\.");
                    sqlSB.append(sortKeys[0]).append(".\"").append(sortKeys[1]).append("\"").append(sortMap.get(sortKey)).append(",");
                    continue;
                }
                sqlSB.append("\"").append(sortKey).append("\" ").append(sortMap.get(sortKey)).append(",");
            }
            sqlSB.deleteCharAt(sqlSB.lastIndexOf(","));
        }
        return sqlSB;
    }

    public StringBuilder initSchemaSql(Connection con, StringBuilder sqlSb, String schema) {
        sqlSb.append("SELECT DISTINCT schemaname AS table_schema FROM pg_tables WHERE tablename NOT LIKE'pg%' AND tablename NOT LIKE'sql_%' ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND schemaname LIKE ").append("'%").append(schema).append("%'");
        }
        return sqlSb;
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) {
        sqlSb.append("SELECT C.relname AS table_name, A.attname AS column_name from pg_class AS C, pg_attribute AS A where C.relname IN ( SELECT tablename FROM pg_tables WHERE tablename NOT LIKE'pg%' AND tablename NOT LIKE'sql_%' ");
        if (StringUtil.isNotBlank((String)table)) {
            sqlSb.append("AND tablename LIKE ").append("'%").append(table).append("%' ");
        }
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND schemaname = '").append(schema).append("' ");
        }
        sqlSb.append("ORDER BY tablename limit 10 offset 0 ) AND A.attrelid = C.oid AND A.attnum > 0 AND NOT A.attisdropped ");
        sqlSb.append("order by A.attnum ");
        return sqlSb;
    }

    public StringBuilder initTableNameListSql(Connection con, StringBuilder sqlSb, List<String> tableNameList, String schema) {
        sqlSb.append("SELECT C.relname as table_name, A.attname AS column_name from pg_class AS C, pg_attribute AS A where C.relname IN ( SELECT tablename FROM pg_tables WHERE tablename NOT LIKE'pg%' AND tablename NOT LIKE'sql_%' ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND schemaname = '").append((CharSequence)sqlSb).append("' ");
        }
        sqlSb.append("ORDER BY tablename ) AND A.attrelid = C.oid AND C.relname in (");
        for (String s : tableNameList) {
            sqlSb.append("'").append(s).append("',");
        }
        sqlSb.delete(sqlSb.length() - 1, sqlSb.length());
        sqlSb.append(") and A.attnum > 0");
        return sqlSb;
    }

    public StringBuilder initPageSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Page page = dbQuery.getPage();
        if (page == null) {
            return sqlSB;
        }
        Integer pageNum = page.getPageNum();
        Integer pageSize = page.getPageSize();
        Integer skip = null;
        if (pageNum != null && pageSize != null) {
            skip = (pageNum - 1) * pageSize;
        }
        if (skip != null) {
            sqlSB.append(" limit ").append(pageSize).append(" offset ").append(skip);
        }
        return sqlSB;
    }

    public StringBuilder initInsertConditionSql(DBInsert insert, Connection con) {
        String insertType = insert.getInsertType();
        StringBuilder paramSb = new StringBuilder();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("insert into \"").append(insert.getTable()).append("\"");
        paramSb.append(" (");
        Map insertColumns = insert.getInsertColumns();
        if (insertColumns == null) {
            List list = insert.getInsertColumnsBatch();
            insertColumns = (Map)list.get(0);
        }
        StringBuilder valueSb = new StringBuilder();
        StringBuilder replaceParams = new StringBuilder();
        LinkedHashMap newInsertColumns = new LinkedHashMap(insertColumns.size());
        for (Map.Entry aMap : insertColumns.entrySet()) {
            String keyTemp;
            Object value;
            if (!insert.isBatch() && (value = aMap.getValue()) == null) continue;
            paramSb.append((String)aMap.getKey()).append(StrSplit.D);
            valueSb.append("?,");
            if ("replace".equalsIgnoreCase(insertType)) {
                replaceParams.append((String)aMap.getKey()).append("=excluded.").append((String)aMap.getKey()).append(",");
            }
            if ((keyTemp = (String)aMap.getKey()).startsWith("\"") && keyTemp.startsWith("\"")) {
                keyTemp = keyTemp.substring(1, keyTemp.length() - 1);
            }
            newInsertColumns.put(keyTemp, aMap.getValue());
        }
        paramSb.delete(paramSb.length() - 1, paramSb.length());
        paramSb.append(") values ");
        sqlSb.append((CharSequence)paramSb);
        valueSb.delete(valueSb.length() - 1, valueSb.length());
        StringBuilder batchValueSb = new StringBuilder();
        batchValueSb.append("(").append((CharSequence)valueSb).append("),");
        List insertBatchColumns = insert.getInsertColumnsBatch();
        if (insert.isBatch()) {
            String valuesSql = batchValueSb.toString();
            for (int i = 1; i < insertBatchColumns.size(); ++i) {
                valueSb = batchValueSb.append(valuesSql);
            }
            if (valueSb.toString().endsWith(",")) {
                valueSb.delete(valueSb.length() - 1, valueSb.length());
            }
        } else {
            valueSb = batchValueSb.delete(batchValueSb.length() - 1, batchValueSb.length());
        }
        insert.setInsertColumns(newInsertColumns);
        sqlSb.append((CharSequence)valueSb);
        if ("ignore".equalsIgnoreCase(insertType)) {
            sqlSb.append(" on conflict do nothing");
        } else if ("replace".equalsIgnoreCase(insertType)) {
            replaceParams.delete(replaceParams.length() - 1, replaceParams.length());
            sqlSb.append(" on conflict (\"").append(insert.getPkName()).append("\") do update set ");
            sqlSb.append((CharSequence)replaceParams);
        }
        return sqlSb;
    }

    public Map<String, Object> initParamsSql(Map<String, Object> queryParams, String dbName, String tableName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> param : queryParams.entrySet()) {
            if (NumberUtils.isNumber((String)param.getKey())) {
                result.put(param.getKey(), param.getValue());
                continue;
            }
            result.put("\"" + param.getKey() + "\"", param.getValue());
        }
        return result;
    }

    public JSONArray initInSql(JSONArray jsonArray, String dbName, String tableName) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject in = jsonArray.getJSONObject(i);
            in.put("key", (Object)("\"" + in.getString("key") + "\""));
            result.add((Object)in);
        }
        return result;
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas((Connection)conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema((Connection)conn, null, (String)schema, (String)tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable((Connection)conn, null, (String)schema, (String)tableName);
    }
}

