/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.mysql;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.base.DBWriteUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class MysqlInsertBatchProcess
implements IProcess {
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IDBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBWriteUtil dbWriteUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        JSONObject insertJson = this.insertData(content);
        this.outputUtil.unfoldPutData(content, (Map)insertJson);
    }

    public JSONObject insertData(ProcessContent content) throws BizException {
        Map insertParams;
        JSONObject conf = content.getStepConf();
        String table = conf.getString("table");
        String db = conf.getString("db");
        DBInsert insert = new DBInsert();
        if (conf.containsKey((Object)"insertParamsBatch")) {
            if (!conf.containsKey((Object)"paramsKey")) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "paramsKey_is_null");
            }
            insertParams = conf.getJSONObject("insertParamsBatch");
            Object insertParamsObject = this.inputUtil.getHandleData(content, "insertParams");
            insert.setBatch(true);
            insert.setInsertColumnsBatch((List)insertParamsObject);
        } else {
            insertParams = this.dBManager.getInsertParams(content);
        }
        if (insertParams == null || insertParams.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "insert_data_is_null");
        }
        insert.setTable(table);
        insert.setInsertColumns(insertParams);
        JSONObject insertResult = this.dbWriteUtil.insert(insert, db, content.getTransactionCon());
        JSONObject insertJson = new JSONObject();
        if (insert.isBatch()) {
            insertJson.put("count", insertResult.get((Object)"count"));
        } else {
            insertJson.put(insertResult.getString("pkName"), (Object)insertResult.getString("pkNum"));
        }
        return insertJson;
    }

    public String getName() {
        return "mysqlInsertBatch";
    }
}

