/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.log.Formatter;
import com.manatee.lowcode.log.ManateeLoggerContext;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootLogger;
import org.slf4j.MDC;

public class Log4jLoggerContext
implements ManateeLoggerContext {
    @Override
    public void generateAppender() {
        RootLogger logger = (RootLogger)LogManager.getRootLogger();
        PatternLayout patternLayout = new PatternLayout("%d %p [%c] - %m%n");
        ManateeLog4jAppender manateeLog4jAppender = new ManateeLog4jAppender();
        manateeLog4jAppender.setLayout((Layout)patternLayout);
        logger.addAppender((Appender)manateeLog4jAppender);
    }

    static class ManateeLog4jAppender
    extends AppenderSkeleton {
        ManateeLog4jAppender() {
        }

        protected void append(LoggingEvent event) {
            String requestId = MDC.get((String)"traceId");
            if (StrUtil.isBlank((CharSequence)requestId) || !requestId.startsWith("D-")) {
                return;
            }
            String loggerName = event.getLoggerName();
            String message = Formatter.create().timestamp(event.getTimeStamp()).value(" --- [").traceId(requestId).value("] ").level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").loggerName(loggerName).value(": ").value(event.getRenderedMessage()).newline().throwable(event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable()).toString();
            boolean isJsProcess = false;
            if (loggerName.endsWith("JsProcess")) {
                isJsProcess = true;
            }
            ManateeLoggerContext.println(message, isJsProcess);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

