/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.string;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@Service
public class StrParamsReplaceFun
extends AbstractFunction {
    private String name = "strParamsReplace";
    private String DKH = "\\{\\}";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        String str = (String)content.getParameter(0);
        if (str.contains(this.DKH)) {
            return str;
        }
        String[] strs = str.split(this.DKH);
        if (str.endsWith("{}")) {
            int length = strs.length;
            strs = Arrays.copyOf(strs, length + 1);
            strs[length] = "";
        }
        StringBuilder sb = new StringBuilder(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            String replaceFrom = (String)content.getParameter(i);
            if (replaceFrom == null) {
                replaceFrom = "";
            }
            sb.append(replaceFrom).append(strs[i]);
        }
        return sb.toString();
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return Integer.MAX_VALUE;
    }
}

