/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.change;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ToJsonFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(ToJsonFun.class);
    private String name = "toJson";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        Object obj = content.getParameter(0);
        if (obj instanceof JSON) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return JSONObject.toJSON((Object)map);
        }
        try {
            if (obj instanceof String) {
                String str = (String)obj;
                return JSON.parse((String)str, (Feature[])new Feature[]{Feature.OrderedField});
            }
            return JSON.toJSON((Object)obj);
        }
        catch (Throwable e) {
            log.error("[JsonFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u8f6cjson\u5f02\u5e38", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

