/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.time;

import com.manatee.fun.FunctionUtil;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.TimeUtil;
import com.manatee.lowcode.fun.time.LastDayCalFun;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

@Service
public class LastDayNumCalFun
extends LastDayCalFun {
    private String name = "lastDayNumCal";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object doFunction(FunctionContent content) {
        Object result = null;
        List parameters = content.getParameters();
        if (!FunctionUtil.checkParameter((List)parameters, (int)1)) {
            return result;
        }
        String condition = (String)parameters.get(0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if ("thisY".equals(condition)) {
            Date date = this.getThisYear(parameters, calendar);
            Date dateCal = this.addDay(date, -1);
            return this.getDifDays(dateCal);
        }
        Pair<Integer, String> confDate = this.getConfDate(condition);
        if ("M".equals(confDate.getRight())) {
            calendar.add(2, (Integer)confDate.getLeft() * -1);
        } else {
            calendar.add(1, (Integer)confDate.getLeft() * -1);
        }
        calendar.add(6, -1);
        Date date = calendar.getTime();
        return this.getDifDays(date);
    }

    private Date addDay(Date date, int dif) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, dif);
        return calendar.getTime();
    }

    private int getDifDays(Date date) {
        Date now = new Date();
        long days = (now.getTime() - date.getTime()) / 86400000L;
        return Integer.valueOf(days + "");
    }

    private Date getThisYear(List<Object> parameters, Calendar calendar) {
        int year = calendar.get(1);
        String day = year + "0101";
        String format = "yyyyMMdd";
        if (parameters.size() >= 2) {
            format = (String)parameters.get(1);
        }
        if ("yyyyMMdd".equals(format)) {
            try {
                return TimeUtil.format2Date((String)day, (String)"yyyyMMdd");
            }
            catch (ParseException e) {
                return null;
            }
        }
        try {
            return TimeUtil.format2Date((String)day, (String)"yyyyMMdd");
        }
        catch (ParseException e) {
            return null;
        }
    }
}

