/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.change;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XmlToJsonFun
extends AbstractFunction {
    protected static Logger log = LoggerFactory.getLogger(XmlToJsonFun.class);

    public String getName() {
        return "xmlToJson";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        String xmlStr = (String)content.getParameter(0);
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            JSONObject json = new JSONObject();
            XmlToJsonFun.dom4j2Json(doc.getRootElement(), json);
            return json;
        }
        catch (Throwable e) {
            log.error("[XmlToJsonFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0cxml\u8f6cjson\u5f02\u5e38", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }

    public static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (XmlToJsonFun.isEmpty(attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !XmlToJsonFun.isEmpty(element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                XmlToJsonFun.dom4j2Json(e, chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add((Object)jsono);
                        jsona.add((Object)chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add((Object)chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (XmlToJsonFun.isEmpty(attr.getValue())) continue;
                json.put("@" + attr.getName(), (Object)attr.getValue());
            }
            if (e.getText().isEmpty()) continue;
            json.put(e.getName(), (Object)e.getText());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }
}

