/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.check;

import com.manatee.check.ICheck;
import com.manatee.check.domain.CheckContent;
import com.manatee.common.util.tool.core.util.ReUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class RegexCheck
implements ICheck {
    @Resource
    private InputUtil inputUtil;
    private Pattern compileListSize = Pattern.compile("size\\((.*?)\\)");

    public String getName() {
        return "regex";
    }

    public void doCheck(CheckContent content) {
        this.regexCheck(content);
        if (!content.isSuccess()) {
            content.setMsg(content.getMsg() + " \u4e0d\u5408\u6cd5");
        }
    }

    protected void regexCheck(CheckContent content) {
        Map paramsKeyValue = content.getParamsKeyValue();
        String[] params = content.getParams().split(",");
        String regex = content.getExpression();
        if (regex.indexOf("size(") != -1) {
            regex = this.getListSize((ProcessContent)content, regex);
        }
        for (String param : params) {
            Object value = paramsKeyValue.get(param);
            if (value == null || ReUtil.isMatch((String)regex, (CharSequence)value.toString())) continue;
            content.setSuccess(false);
            content.setMsg(value.toString());
            return;
        }
        content.setSuccess(true);
    }

    private String getListSize(ProcessContent content, String checkRule) {
        List values = ReUtil.findAll((Pattern)this.compileListSize, (CharSequence)checkRule, (int)1);
        List allGroups = ReUtil.findAll((Pattern)this.compileListSize, (CharSequence)checkRule, (int)0);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        String result = null;
        int size = 0;
        for (int i = 0; i < values.size(); ++i) {
            String variable = ((String)values.get(i)).trim();
            String expression = (String)allGroups.get(i);
            Object arrayObj = this.inputUtil.getData(content, variable);
            if (!(arrayObj instanceof List)) continue;
            List arrayList = (List)arrayObj;
            size = arrayList.size();
            result = StrUtil.replace((CharSequence)checkRule, (CharSequence)expression, (CharSequence)(size + ""));
        }
        return result;
    }
}

