/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.check;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.check.ICheck;
import com.manatee.check.domain.CheckContent;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.ReUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.ManateeConditionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ExpressionCheckV2
implements ICheck {
    @Resource
    private ManateeConditionUtil manateeConditionUtil;
    @Resource
    private InputUtil inputUtil;
    private Pattern compileListSize = Pattern.compile("size\\((.*?)\\)");
    private static final String CONDITION_VARIABLES_PREFIX = "TEMP_VARIABLES_%s";

    public String getName() {
        return "expression_v2";
    }

    public void doCheck(CheckContent content) {
        this.expressionCheck(content);
        if (!content.isSuccess()) {
            content.setMsg(content.getParams() + " \u4e0d\u6ee1\u8db3 " + content.getExpression());
        }
    }

    protected void expressionCheck(CheckContent content) {
        Map paramsKeyValue = content.getParamsKeyValue();
        String[] params = content.getParams().split(",");
        String expression = content.getExpression();
        if (expression.indexOf("size(") != -1) {
            expression = this.getListSize((ProcessContent)content, expression);
        }
        for (String param : params) {
            if (this.manateeConditionUtil.isHappened(expression, (ProcessContent)content)) continue;
            content.setSuccess(false);
            content.setMsg(param);
            return;
        }
        content.setSuccess(true);
    }

    private String getListSize(ProcessContent content, String checkRule) {
        List values = ReUtil.findAll((Pattern)this.compileListSize, (CharSequence)checkRule, (int)1);
        List allGroups = ReUtil.findAll((Pattern)this.compileListSize, (CharSequence)checkRule, (int)0);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        String result = null;
        int size = 0;
        for (int i = 0; i < values.size(); ++i) {
            JSONArray array;
            String variable = ((String)values.get(i)).trim();
            String expression = (String)allGroups.get(i);
            Object value = this.inputUtil.getData(content, variable);
            HashMap<String, Integer> tempData = content.getTempData();
            if (tempData == null) {
                tempData = new HashMap<String, Integer>();
                content.setTempData(tempData);
            }
            String valName = String.format(CONDITION_VARIABLES_PREFIX, variable);
            if (value instanceof List) {
                List arrayList = (List)value;
                size = arrayList.size();
            } else if (value instanceof Set) {
                Set list = (Set)value;
                size = list.size();
            } else if (value instanceof Map) {
                Map map = (Map)value;
                size = map.size();
            } else if (value.getClass().isArray()) {
                Object[] data = (Object[])value;
                size = data.length;
            } else if (value instanceof JSONArray) {
                array = (JSONArray)value;
                size = array.size();
            } else if (value instanceof JSONObject) {
                array = (JSONObject)value;
                size = array.size();
            } else if (value instanceof String) {
                size = this.getStrSize(value);
            }
            tempData.put(valName, size);
            result = StrUtil.replace((CharSequence)checkRule, (CharSequence)expression, (CharSequence)valName);
        }
        return result;
    }

    private boolean isJSON(String str) {
        boolean result = false;
        if (StringUtil.isNotBlank((String)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    private int getStrSize(Object value) {
        String str = (String)value;
        if (!this.isJSON(str)) {
            return str.length();
        }
        try {
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                return array.size();
            }
            if (value instanceof JSONObject) {
                JSONObject array = (JSONObject)value;
                return array.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str.length();
    }
}

