/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.baseModule.manager;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.lowcode.baseModule.init.BaseModuleInit;
import com.manatee.lowcodedb.base.DBReadUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaseModuleUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(BaseModuleUtil.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private DBReadUtil DBReadUtil;
    @Autowired
    private Map<String, BaseModuleInit> baseModuleInitServices;
    private Map<String, JSONObject> PROCESS_CONF_MAP = new HashMap<String, JSONObject>();
    private static final Map<String, JSONObject> CUSTOM_PROCESS_CONF_MAP = new HashMap<String, JSONObject>();
    private static final Map<String, JSONObject> CUSTOM_PROJECT_CONF_MAP = new HashMap<String, JSONObject>();

    private static List<String> getBaseModuleList() {
        ArrayList<String> baseModuleList = new ArrayList<String>();
        baseModuleList.add("queryDatasource");
        baseModuleList.add("getTablesColumns");
        baseModuleList.add("customFunctionExpand");
        baseModuleList.add("getRunMethodProcessParams");
        baseModuleList.add("getManateeVersion");
        baseModuleList.add("queryOneModuleForWangfa");
        baseModuleList.add("addModuleForWangfa");
        baseModuleList.add("updateModuleForWangfa");
        baseModuleList.add("queryProjectConfForWangfa");
        baseModuleList.add("addProjectConfForWangfa");
        baseModuleList.add("updateProjectConfForWangfa");
        baseModuleList.add("getBusinessDatabaseType");
        baseModuleList.add("decrypt");
        baseModuleList.add("queryModuleListForWangfa");
        baseModuleList.add("queryModuleCountForWangfa");
        baseModuleList.add("getComponentLoadList");
        baseModuleList.add("queryTestCaseList");
        baseModuleList.add("batchDeleteModuleForWangfa");
        baseModuleList.add("batchMoveModuleForWangfa");
        baseModuleList.add("inQueryModuleListByCodeListForWangfa");
        baseModuleList.add("batchAddModuleForWangfa");
        baseModuleList.add("queryModuleForByIds");
        baseModuleList.add("batchSyncModuleForWangfa");
        baseModuleList.add("moveModuleForWangfa");
        baseModuleList.add("getTablesInfoForWangfa");
        baseModuleList.add("batchAddModuleCrudForWangfa");
        baseModuleList.add("getAllTablesColumnForWangfa");
        baseModuleList.add("queryPublishedModuleForWangfa");
        baseModuleList.add("compilerJavaCode");
        baseModuleList.add("getProjectRunningStatusForWangfa");
        baseModuleList.add("getMongoTableColumns");
        baseModuleList.add("queryMongoDatasourceOptions");
        baseModuleList.add("getTableNameListColumns");
        baseModuleList.add("getEnumAttribute");
        baseModuleList.add("getTablesColumnsNewStructure");
        baseModuleList.add("getSchemas");
        baseModuleList.add("getTablesColumnsNewStructureBySchema");
        baseModuleList.add("getTablesBySchema");
        baseModuleList.add("getColumnsBySchemaAndTable");
        baseModuleList.add("loadProjectConfDbsByProjectId");
        baseModuleList.add("fileExport");
        return baseModuleList;
    }

    public Map<String, JSONObject> getAllBaseModule() {
        List<String> baseModuleList = BaseModuleUtil.getBaseModuleList();
        try {
            for (String fileName : baseModuleList) {
                JSONObject jsonObject = JSONObject.parseObject((String)BaseModuleUtil.parseFile("baseModuleFiles/" + fileName + ".json"), (Feature[])new Feature[]{Feature.OrderedField});
                this.PROCESS_CONF_MAP.put(fileName, jsonObject);
            }
            Collection<BaseModuleInit> values = this.baseModuleInitServices.values();
            for (BaseModuleInit baseModuleInit : values) {
                Map<String, JSONObject> map = baseModuleInit.initBaseMoudle();
                this.PROCESS_CONF_MAP.putAll(map);
            }
        }
        catch (Exception e) {
            LOGGER.error("getAllBaseModule error :{}", (Throwable)e);
        }
        return this.PROCESS_CONF_MAP;
    }

    public static String parseFile(String path) {
        try {
            InputStream resourceAsStream = BaseModuleUtil.class.getClassLoader().getResourceAsStream(path);
            assert (resourceAsStream != null);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(resourceAsStream);
            StringBuilder sb = new StringBuilder();
            byte[] bytes = new byte[1024];
            int len = -1;
            while ((len = bufferedInputStream.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
            resourceAsStream.close();
            bufferedInputStream.close();
            return sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("BaseModuleUtil.parseFile() error, path:\u3010{}\u3011, e: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public static void getAllCustomConf(org.springframework.core.io.Resource[] resources, Map<String, JSONObject> map) {
        if (resources == null) {
            LOGGER.error("\u5f53\u524d\u4e3afile\u6a21\u5f0f\u8bf7\u5728classPath\u76ee\u5f55\u4e0b\u653e\u5165\u8d44\u6e90\u6587\u4ef6:lowcodeBaseModules, lowcodeProjectConf");
            return;
        }
        for (org.springframework.core.io.Resource resource : resources) {
            if (!resource.exists()) continue;
            StringBuffer script = new StringBuffer();
            try (InputStreamReader isr = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                 BufferedReader bufferReader = new BufferedReader(isr);){
                String tempString;
                while ((tempString = bufferReader.readLine()) != null) {
                    script.append(tempString).append("\n");
                }
                JSONObject jsonObject = JSONObject.parseObject((String)script.toString());
                String key = FileUtil.mainName((String)resource.getFilename());
                LOGGER.info("getAllCustomConf load:{}, uri:{}", (Object)key, (Object)resource.getFilename());
                map.put(key, jsonObject);
            }
            catch (IOException e) {
                LOGGER.error("getAllCustomConf error, e{}", (Throwable)e);
            }
        }
    }

    public static void getAllCustomConf(File file, Map<String, JSONObject> map) {
        File[] files;
        if (!file.exists()) {
            LOGGER.error("getAllCustomConf errr, file not exists, \u3010{}\u3011", (Object)file.getPath());
            return;
        }
        for (File file1 : files = file.listFiles()) {
            if (file1.isDirectory()) continue;
            String string = FileUtil.readString((File)file1, (Charset)Charset.defaultCharset());
            JSONObject jsonObject = JSONObject.parseObject((String)string.toString());
            String key = FileUtil.mainName((String)file1.getName());
            LOGGER.info("getAllCustomConf load:{}, uri:{}", (Object)key, (Object)file1.getPath());
            map.put(key, jsonObject);
        }
    }

    public boolean isExistTable(String table) {
        if (this.defaultDatabaseProductName.equals("dameng")) {
            table = "\"" + table + "\"";
        }
        String sql = "select count(*) as \"count\" from " + table;
        try {
            DBQuery dbQuery = new DBQuery();
            dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            dbQuery.setDb("default");
            dbQuery.setSelectOne(Boolean.valueOf(true));
            dbQuery.setSql(sql);
            this.DBReadUtil.executeSelectSql(dbQuery, null);
            return true;
        }
        catch (BizException e) {
            return false;
        }
    }

    public void initBaseTable(String table) {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        String initSql = BaseModuleUtil.parseFile("initTableFiles/" + table + "/" + this.defaultDatabaseProductName + ".sql");
        if (initSql != null && initSql.contains(";")) {
            String[] initSqlArray = initSql.split(";");
            try {
                for (String sql : initSqlArray) {
                    LOGGER.debug(sql);
                    dbQuery.setSql(sql);
                    this.DBReadUtil.executeNotSelectStatementSql(dbQuery, null);
                }
            }
            catch (BizException e) {
                LOGGER.error("\u521d\u59cb\u5316\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u521b\u5efa", (Object)table);
            }
        } else {
            dbQuery.setSql(initSql);
            try {
                this.DBReadUtil.executeNotSelectSql(dbQuery, null);
            }
            catch (BizException e) {
                LOGGER.error("\u521d\u59cb\u5316\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u521b\u5efa", (Object)table);
            }
        }
    }

    public Map<String, JSONObject> getPROCESS_CONF_MAP() {
        return this.PROCESS_CONF_MAP;
    }

    public static Map<String, JSONObject> getCUSTOM_PROCESS_CONF_MAP() {
        return CUSTOM_PROCESS_CONF_MAP;
    }

    public static Map<String, JSONObject> getCUSTOM_PROJECT_CONF_MAP() {
        return CUSTOM_PROJECT_CONF_MAP;
    }
}

