/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.autoconfig;

import com.manatee.annotations.ManateeProcess;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ManateeClassScanner {
    public static List<String> scan(String packagePath) throws URISyntaxException, IOException {
        ClassLoader loader;
        HashSet<String> classes = new HashSet<String>();
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 11.0) {
            classes.addAll(ManateeClassScanner.latestJdkScan());
        } else {
            loader = Thread.currentThread().getContextClassLoader();
            do {
                if (!(loader instanceof URLClassLoader)) continue;
                classes.addAll(ManateeClassScanner.scan(((URLClassLoader)loader).getURLs(), packagePath));
            } while ((loader = loader.getParent()) != null);
        }
        loader = Thread.currentThread().getContextClassLoader();
        do {
            if (!(loader instanceof URLClassLoader)) continue;
            classes.addAll(ManateeClassScanner.scan(((URLClassLoader)loader).getURLs(), packagePath));
        } while ((loader = loader.getParent()) != null);
        return new ArrayList<String>(classes);
    }

    public static List<String> latestJdkScan() throws IOException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resourcePatternResolver.getResources("classpath*:**/**.class");
        return Arrays.asList(resources).parallelStream().map(it -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
    }

    public static String compress(List<String> classes) {
        Collections.sort(classes);
        String currentPackage = "";
        StringBuffer buf = new StringBuffer();
        int classCount = 0;
        for (String fullName : classes) {
            String packageName = "";
            String className = fullName;
            if (fullName.contains(".")) {
                int index = fullName.lastIndexOf(".");
                className = fullName.substring(index + 1);
                packageName = fullName.substring(0, index);
            }
            if (className.equals("package-info")) continue;
            if (currentPackage.equals(packageName)) {
                if (classCount > 0) {
                    buf.append(",");
                }
                buf.append(className);
                ++classCount;
                continue;
            }
            currentPackage = packageName;
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(packageName);
            buf.append(":");
            buf.append(className);
            classCount = 1;
        }
        return buf.toString();
    }

    private static Set<String> scan(URL[] urls, String packagePath) throws URISyntaxException {
        HashSet<String> classes = new HashSet<String>();
        if (urls != null) {
            for (URL url : urls) {
                String protocol = url.getProtocol();
                if ("file".equalsIgnoreCase(protocol)) {
                    String path = url.getPath();
                    if (path.toLowerCase().endsWith(".jar")) {
                        classes.addAll(ManateeClassScanner.scanJarFile(url, packagePath));
                        continue;
                    }
                    classes.addAll(ManateeClassScanner.scanDirectory(new File(url.toURI()), null, packagePath));
                    continue;
                }
                if (!"jar".equalsIgnoreCase(protocol)) continue;
                classes.addAll(ManateeClassScanner.scanJarFile(url, packagePath));
            }
        }
        return classes;
    }

    private static int checkJavaVersion() {
        String version = System.getProperty("java.version");
        int index = version.indexOf(".");
        if (index > -1) {
            String first = version.substring(0, index);
            if (!"1".equals(first)) {
                return ManateeClassScanner.asInt(first, -1);
            }
            int endIndex = version.indexOf(".", index + 1);
            return ManateeClassScanner.asInt(version.substring(index + 1, endIndex), -1);
        }
        return -1;
    }

    public static int asInt(Object val, int defaultValue) {
        try {
            return new Integer(val.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static Set<String> addJava9PlusLibrary() {
        HashSet<String> classes = new HashSet<String>();
        try {
            Class<?> moduleLayer = Class.forName("java.lang.ModuleLayer");
            Object boot = moduleLayer.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            Object configuration = moduleLayer.getMethod("configuration", new Class[0]).invoke(boot, new Object[0]);
            Set modules = (Set)Class.forName("java.lang.module.Configuration").getMethod("modules", new Class[0]).invoke(configuration, new Object[0]);
            Method reference = Class.forName("java.lang.module.ResolvedModule").getMethod("reference", new Class[0]);
            Method open = Class.forName("java.lang.module.ModuleReference").getMethod("open", new Class[0]);
            Method list = Class.forName("java.lang.module.ModuleReader").getMethod("list", new Class[0]);
            modules.forEach(module -> {});
            for (Object module2 : modules) {
                Object ref = reference.invoke(module2, new Object[0]);
                try {
                    Closeable reader = (Closeable)open.invoke(ref, new Object[0]);
                    Throwable throwable = null;
                    try {
                        Stream stream = (Stream)list.invoke((Object)reader, new Object[0]);
                        stream.filter(ManateeClassScanner::isClass).forEach(className -> classes.add(className.substring(0, className.length() - 6).replace("/", ".")));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static List<String> scanDirectory(File dir, String packageName, String sacnPackagePath) {
        File[] files = dir.listFiles();
        ArrayList<String> classes = new ArrayList<String>();
        if (files != null) {
            block2: for (File file : files) {
                String name = file.getName();
                if (file.isDirectory()) {
                    classes.addAll(ManateeClassScanner.scanDirectory(file, packageName == null ? name : packageName + "." + name, sacnPackagePath));
                    continue;
                }
                if (!name.endsWith(".class") || name.contains("$")) continue;
                String fullName = ManateeClassScanner.filterFullName(packageName + "." + name.substring(0, name.length() - 6));
                try {
                    Method[] methods;
                    if (!fullName.startsWith(sacnPackagePath)) break;
                    Class<?> aClass = Class.forName(fullName);
                    for (Method method : methods = aClass.getMethods()) {
                        if (!method.isAnnotationPresent(ManateeProcess.class)) continue;
                        classes.add(fullName);
                        continue block2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return classes;
    }

    private static String filterFullName(String fullName) {
        if (fullName.startsWith("BOOT-INF.classes.")) {
            fullName = fullName.substring(17);
        }
        return fullName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> scanJarFile(URL url, String packagePath) {
        ArrayList<String> classes = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
            ZipEntry entry;
            block13: while ((entry = zis.getNextEntry()) != null) {
                String className;
                if (entry.getName().contains("META-INF") || !ManateeClassScanner.isClass(className = entry.getName())) continue;
                String fullName = ManateeClassScanner.filterFullName(className.substring(0, className.length() - 6).replace("/", "."));
                try {
                    Method[] methods;
                    if (!fullName.startsWith(packagePath)) {
                        return classes;
                    }
                    Class<?> aClass = Class.forName(fullName);
                    Method[] methodArray = methods = aClass.getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block13;
                        Method method = methodArray[n2];
                        if (method.isAnnotationPresent(ManateeProcess.class)) {
                            classes.add(fullName);
                            continue block13;
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                }
            }
            return classes;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static boolean isClass(String className) {
        return className.endsWith(".class") && !className.contains("$") && !className.contains("module-info");
    }

    public static void main(String[] args) throws URISyntaxException, IOException {
        long start = System.currentTimeMillis();
        List<String> scan = ManateeClassScanner.scan("com.manatee");
        System.out.println(System.currentTimeMillis() - start);
    }
}

