/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.webservice.type;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.HttpUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.EscapeUtil;
import com.manatee.lowcode.util.ProcessParamUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.webservice.type.BaseWebServiceClient;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.springframework.stereotype.Component;

@Component
public class RestClient
extends BaseWebServiceClient {
    @Resource
    private VariableUtil variableUtil;
    JaxWsDynamicClientFactory factory = JaxWsDynamicClientFactory.newInstance();

    public void handle(ProcessContent content) throws Exception {
        String response;
        Map params;
        String url = this.variableUtil.calVarInConf(content, "url");
        Object paramObject = content.getStepConf().get((Object)"params");
        JSONObject paramJson = null;
        if (paramObject instanceof JSONObject || paramObject instanceof Map) {
            paramJson = (JSONObject)paramObject;
        }
        if ((params = this.inputUtil.getHandleObject(content, "params")) != null && params.size() > 0) {
            url = this.appendUrl(url, params, paramJson);
        }
        if (StringUtil.isBlank((String)(response = HttpUtils.request((String)url, null, null, (String)"GET")))) {
            throw new BizException(ResultCode.RESULT_IS_NULL, "http_result_is_null");
        }
        this.handleData(content, response);
    }

    private String appendUrl(String url, Map<String, Object> params, JSONObject paramJson) {
        String firstStr = "?";
        if (url.indexOf("?") != -1) {
            firstStr = "&";
        }
        StringBuilder sb = new StringBuilder(url);
        int index = 0;
        for (Map.Entry<String, Object> aMap : params.entrySet()) {
            if (index == 0) {
                sb.append(firstStr);
            } else {
                sb.append("&");
            }
            Object value = aMap.getValue();
            if (null == value && paramJson != null) {
                value = paramJson.get((Object)aMap.getKey());
            }
            if (value instanceof Map) {
                JSONObject json = new JSONObject();
                json.putAll((Map)value);
                value = EscapeUtil.escape((String)json.toString());
            }
            sb.append(aMap.getKey()).append("=").append(value);
            ++index;
        }
        return sb.toString();
    }

    private Object invoke(ProcessContent content, Client client, Object[] params) throws Exception {
        Object data;
        Object[] objects;
        String namespace = this.getNamespace(content);
        String method = ProcessParamUtil.getParam((ProcessContent)content, (String)"method");
        if (StringUtil.isNotBlank((String)namespace)) {
            QName q = new QName(namespace, method);
            objects = client.invoke(q, params);
        } else {
            objects = client.invoke(method, params);
        }
        if (objects.length > 0 && (data = objects[0]) != null) {
            return data;
        }
        return null;
    }

    private String getNamespace(ProcessContent content) {
        String namespace = content.getStepConfString("namespace");
        if (StringUtil.isNotBlank((String)namespace)) {
            return namespace;
        }
        return null;
    }
}

