/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.other;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.impl.system.ThrowsExceptionProcess;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThrowExceptionFun
extends AbstractFunction {
    protected static Logger LOGGER = LoggerFactory.getLogger(ThrowExceptionFun.class);

    public String getName() {
        return "throwException";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        List parameters = content.getParameters();
        String type = null;
        String msg = null;
        Object status = null;
        if (parameters == null || parameters.size() == 0) {
            type = "biz_error";
        } else if (parameters.size() == 1) {
            type = content.getParameter(0).toString();
        } else if (parameters.size() == 2) {
            type = content.getParameter(0).toString();
            msg = content.getParameter(1).toString();
        } else if (parameters.size() == 3) {
            type = content.getParameter(0).toString();
            msg = content.getParameter(1).toString();
            status = content.getParameter(2);
        }
        String moduleCode = (String)((Map)content.getRequest("tempContext")).get("lowcodeModule");
        String blockName = content.getStepConfString("title");
        switch (type) {
            case "param_is_error": {
                msg = msg == null ? "\u53c2\u6570\u9519\u8bef" : msg;
                status = status == null ? Integer.valueOf(400) : status;
                break;
            }
            case "not_authorized": {
                msg = msg == null ? "\u6ca1\u6709\u6743\u9650" : msg;
                status = status == null ? Integer.valueOf(401) : status;
                break;
            }
            case "biz_error": 
            case "": {
                msg = msg == null ? "\u4e1a\u52a1\u9519\u8bef" : msg;
                status = status == null ? Integer.valueOf(500) : status;
                break;
            }
            case "system_error": {
                msg = msg == null ? "\u7cfb\u7edf\u9519\u8bef" : msg;
                status = status == null ? Integer.valueOf(500) : status;
                break;
            }
            case "conf_error": {
                msg = msg == null ? "\u914d\u7f6e\u9519\u8bef" : msg;
                status = status == null ? Integer.valueOf(510) : status;
            }
        }
        LOGGER.error("\u63a5\u53e3\u540d:\u3010" + moduleCode + "\u3011_ \u7ec4\u4ef6\u540d\u79f0:\u3010" + blockName + "\u3011_ \u6570\u636e\u5904\u7406:\u3010" + msg + "\u3011");
        this.errorLog(type, null, msg, status, content);
        return null;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 3;
    }

    private void errorLog(String code, String subCode, String msg, Object status, FunctionContent content) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)code);
        jsonObject.put("resultSubCode", (Object)subCode);
        jsonObject.put("resultMsg", (Object)msg);
        jsonObject.put("resultStatus", status);
        BizException bizException = ThrowsExceptionProcess.getException((JSONObject)jsonObject, (ProcessContent)content);
        throw new RuntimeException((Throwable)bizException);
    }
}

