/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.other;

import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.iutil.IModularityManager;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ModuleFun
extends AbstractFunction {
    @Resource
    private IModularityManager modularityManager;

    public String getName() {
        return "moduleFunction";
    }

    public Object doFunction(FunctionContent content) throws BizException {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        if (parameters == null || parameters.size() <= 0) {
            return null;
        }
        Object moduleCode = parameters.get(0);
        if (moduleCode == null) {
            return null;
        }
        Object params = null;
        if (parameters.size() > 1) {
            params = parameters.get(1);
        }
        String traceId = content.getTraceId();
        ModularityResult modularityResult = this.modularityManager.executionModule(content.getProjectId(), moduleCode.toString(), params, traceId);
        if (modularityResult.isSuccess()) {
            return modularityResult.getData();
        }
        return modularityResult;
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

