/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.cal;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DecimalFun
extends AbstractFunction {
    public String getName() {
        return "decimal";
    }

    public Object doFunction(FunctionContent content) {
        Object obj3;
        Object obj2;
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        Object obj1 = parameters.get(0);
        String number = String.valueOf(obj1);
        BigDecimal bigDecimal = new BigDecimal(number);
        int scale = 2;
        if (parameters.size() > 1 && (obj2 = parameters.get(1)) != null) {
            scale = Integer.valueOf(obj2.toString());
        }
        double doubleValue = bigDecimal.setScale(scale, 4).doubleValue();
        Object result = doubleValue;
        String type = "str";
        if (parameters.size() > 2 && (obj3 = parameters.get(2)) != null && !obj3.toString().toLowerCase().trim().equals("str")) {
            type = "num";
        }
        if (type.equals("str")) {
            StringBuilder zeroSb = new StringBuilder("0.00");
            if (scale > 0 && scale != 2) {
                zeroSb = new StringBuilder("0.");
                for (int i = 0; i < scale; ++i) {
                    zeroSb = zeroSb.append("0");
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat(zeroSb.toString());
            result = decimalFormat.format(doubleValue);
        }
        return result;
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 3;
    }
}

