/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rocketmq.config;

import com.manatee.common.util.StringUtil;
import com.manatee.rocketmq.manager.ManateeMsgListenerManager;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManateeRocketmqConsumerConfig
implements InitializingBean {
    @Value(value="${rocketmq.consumer.namesrvAddr:}")
    private String namesrvAddr;
    @Value(value="${rocketmq.consumer.groupName:}")
    private String groupName;
    @Value(value="${rocketmq.consumer.topics:}")
    private String topics;
    public static DefaultMQPushConsumer consumer;
    @Resource
    private ManateeMsgListenerManager manateeMsgListenerManager;

    public void afterPropertiesSet() {
        if (StringUtil.isNotBlank((String)this.namesrvAddr) && StringUtil.isNotBlank((String)this.groupName)) {
            try {
                consumer = new DefaultMQPushConsumer(this.groupName);
                consumer.setNamesrvAddr(this.namesrvAddr);
                String[] topicArr = this.topics.split(";");
                consumer.registerMessageListener((MessageListenerConcurrently)this.manateeMsgListenerManager);
                for (String topic : topicArr) {
                    String[] tagArr = topic.split("~");
                    consumer.subscribe(tagArr[0], tagArr[1]);
                }
                consumer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @PreDestroy
    private void destroy() {
        if (consumer != null) {
            consumer.shutdown();
            System.out.println("RocketmqConsumer shutdown......................");
        }
    }
}

