/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.kafka.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.JSONUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.kafka.config.ManateeKfakaConfig;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KfakaConsumerRunnable
extends Thread {
    private Logger log = LoggerFactory.getLogger(KfakaConsumerRunnable.class);
    private ModularityManager modularityManager;
    private Map<String, Object> consumerConfigs;
    private String topicName;
    private String groupId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.warn("\u5f00\u59cb\u6d88\u8d39KfakaonfigRunnable,topic: {} ", (Object)this.topicName);
        if (StringUtil.isNotBlank((String)this.groupId)) {
            this.consumerConfigs.put("group.id", this.groupId);
        }
        KafkaConsumer consumer = new KafkaConsumer(this.consumerConfigs);
        consumer.subscribe(Collections.singletonList(this.topicName));
        try {
            try {
                while (true) {
                    ConsumerRecords records;
                    if ((records = consumer.poll(1500L)).isEmpty()) {
                        Thread.sleep(5000L);
                        continue;
                    }
                    for (ConsumerRecord record : records) {
                        this.log.warn("\u6536\u5230\u6d88\u606f\uff1atopic:" + record.topic() + ",\u5206\u533a\uff1a" + record.partition() + ",key\uff1a" + (String)record.key() + "\uff0c\u6d88\u606f\u5728\u5206\u533a\u4e2d\u7684\u6807\u8bc6\uff1a" + record.offset());
                        Long projectId = 0L;
                        String code = "msgDistribute";
                        JSONObject params = new HashMap();
                        String value = (String)record.value();
                        if (JSONUtils.isJson((String)value)) {
                            params = JSONObject.parseObject((String)value);
                        } else {
                            params.put("value", value);
                        }
                        params.put("_type", record.topic());
                        params.put("_subType", record.key());
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("_type", record.topic());
                        param.put("_subType", record.key());
                        if (params.containsKey("_uniqueid")) {
                            param.put("_uniqueId", params.get("_uniqueid"));
                        }
                        param.put("params", params);
                        ModularityResult modularityResult = this.modularityManager.executionModule(projectId, code, param);
                        this.log.warn(JSONObject.toJSONString((Object)modularityResult));
                    }
                    consumer.commitSync();
                }
            }
            catch (Exception e) {
                this.log.error("KfakaConfigRunnable \u6d88\u8d39\u5f02\u5e38:{},{} ", (Object)this.topicName, (Object)e);
                consumer.close();
                ManateeKfakaConfig.kafkaConsumerRunnablePool.remove(this.topicName);
            }
        }
        catch (Throwable throwable) {
            consumer.close();
            ManateeKfakaConfig.kafkaConsumerRunnablePool.remove(this.topicName);
            throw throwable;
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public ModularityManager getModularityManager() {
        return this.modularityManager;
    }

    public Map<String, Object> getConsumerConfigs() {
        return this.consumerConfigs;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setModularityManager(ModularityManager modularityManager) {
        this.modularityManager = modularityManager;
    }

    public void setConsumerConfigs(Map<String, Object> consumerConfigs) {
        this.consumerConfigs = consumerConfigs;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KfakaConsumerRunnable)) {
            return false;
        }
        KfakaConsumerRunnable other = (KfakaConsumerRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ModularityManager this$modularityManager = this.getModularityManager();
        ModularityManager other$modularityManager = other.getModularityManager();
        if (this$modularityManager == null ? other$modularityManager != null : !this$modularityManager.equals(other$modularityManager)) {
            return false;
        }
        Map<String, Object> this$consumerConfigs = this.getConsumerConfigs();
        Map<String, Object> other$consumerConfigs = other.getConsumerConfigs();
        if (this$consumerConfigs == null ? other$consumerConfigs != null : !((Object)this$consumerConfigs).equals(other$consumerConfigs)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        return !(this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KfakaConsumerRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ModularityManager $modularityManager = this.getModularityManager();
        result = result * 59 + ($modularityManager == null ? 43 : $modularityManager.hashCode());
        Map<String, Object> $consumerConfigs = this.getConsumerConfigs();
        result = result * 59 + ($consumerConfigs == null ? 43 : ((Object)$consumerConfigs).hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KfakaConsumerRunnable(log=" + this.getLog() + ", modularityManager=" + this.getModularityManager() + ", consumerConfigs=" + this.getConsumerConfigs() + ", topicName=" + this.getTopicName() + ", groupId=" + this.getGroupId() + ")";
    }
}

