/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.oracle.store;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OracleDeleteProcess
implements IProcess {
    @Resource
    private IDBManager dBManager;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        int deleteCount = this.dBManager.deleteData(content, "oracle");
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)deleteCount);
    }

    public String getName() {
        return "oracleDelete";
    }
}

