/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.process;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.check.domain.CheckContent;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.ZipUtil;
import com.manatee.excel.domain.WriteExcelBO;
import com.manatee.excel.util.ExceWriteUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.process.ParamCheckProcess;
import com.manatee.lowcode.util.CacheRamUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.stereotype.Service;

@Service
public class ExcelWriteProcess
implements IProcess {
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private ParamCheckProcess paramCheckProcess;
    @Resource
    private CacheRamUtil cacheRamUtil;

    public void process(ProcessContent content) throws BizException {
        String filePassword;
        String fileWatermark;
        File tempDir;
        String fileExtension;
        Boolean isDynamicSheet = content.getStepConf().getBoolean("isDynamicSheet");
        LinkedHashMap<String, List<WriteExcelBO>> fileMap = new LinkedHashMap<String, List<WriteExcelBO>>();
        String file = content.getStepConfString("fileName");
        if (StringUtil.isNotBlank((String)file)) {
            file = this.variableUtil.calVar(content, file);
            content.putTempContent("fileName", (Object)file);
        }
        if (StringUtil.isNotBlank((String)(fileExtension = content.getStepConfString("fileExtension")))) {
            content.putTempContent("fileExtension", (Object)fileExtension);
        }
        if (isDynamicSheet == null || !isDynamicSheet.booleanValue()) {
            this.processConfUtil.checkConf(content, new String[]{"config"});
            JSONArray config = (JSONArray)JSONArray.parse((String)JSON.toJSONString((Object)content.getStepConf("config")), (Feature[])new Feature[]{Feature.OrderedField});
            for (int i = 0; i < config.size(); ++i) {
                JSONObject conf = config.getJSONObject(i);
                JSONObject head = JSONObject.parseObject((String)this.variableUtil.calVar(content, conf.getString("head")), (Feature[])new Feature[]{Feature.OrderedField});
                conf.put("head", (Object)head);
                String dataHandleBatch = this.variableUtil.calVar(content, conf.getString("dataHandleBatch"));
                conf.put("dataHandleBatch", (Object)dataHandleBatch);
                this.handleASheet(content, conf, fileMap);
            }
        }
        if (isDynamicSheet != null && isDynamicSheet.booleanValue()) {
            this.handleDynamicSheet(content, content.getStepConf(), fileMap);
        }
        if (!(tempDir = new File(GlobalConf.TEMP_DIRECTORY)).exists()) {
            tempDir.mkdir();
        }
        if (StringUtil.isNotBlank((String)(fileWatermark = content.getStepConfString("fileWatermark")))) {
            fileWatermark = this.variableUtil.calVar(content, fileWatermark);
        }
        if (StringUtil.isNotBlank((String)(filePassword = content.getStepConfString("filePassword")))) {
            filePassword = this.variableUtil.calVar(content, filePassword);
        }
        JSONObject excelConf = new JSONObject();
        Boolean progressStatus = content.getStepConf().getBoolean("progressStatus");
        if (progressStatus != null && progressStatus.booleanValue()) {
            String progressCount;
            String progressCacheKey = this.variableUtil.calVarInConf(content, "progressCacheKey");
            String progressCacheTime = this.variableUtil.calVarInConf(content, "progressCacheTime");
            if (StringUtils.isBlank((CharSequence)progressCacheTime)) {
                progressCacheTime = "300";
            }
            if (StringUtils.isBlank((CharSequence)(progressCount = this.variableUtil.calVarInConf(content, "progressCount")))) {
                progressCount = "100";
            }
            excelConf.put("progressStatus", (Object)progressStatus);
            excelConf.put("progressCacheKey", (Object)progressCacheKey);
            excelConf.put("progressCacheTime", (Object)Integer.parseInt(progressCacheTime));
            excelConf.put("progressCount", (Object)Integer.parseInt(progressCount));
        }
        Boolean isAddition = content.getStepConf().getBoolean("isAddition");
        excelConf.put("isAddition", (Object)isAddition);
        this.writeExcels(fileMap, fileExtension, fileWatermark, filePassword, excelConf);
        List<String> fileList = this.getFileList(fileMap);
        String zipFileName = this.zip(content, fileList);
        String fileName = this.getFileName(fileList, zipFileName);
        if (fileName == null) {
            throw new BizException(ResultCode.BIZ_ERROR, "excel_file_is_null");
        }
        String url = GlobalConf.TEMP_DIRECTORY + fileName;
        content.getStepConf().put("returnKey", (Object)"lowcodeTempExcelUrl");
        this.outputUtil.putData(content, (Object)url);
    }

    private String getFileName(List<String> fileList, String zipFileName) {
        String fileName = null;
        if (zipFileName != null) {
            fileName = zipFileName;
        } else if (fileList.size() > 0) {
            fileName = fileList.get(0);
        }
        return fileName;
    }

    private void handleDynamicSheet(ProcessContent content, JSONObject conf, Map<String, List<WriteExcelBO>> fileMap) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"loopArrayName"});
        String loopArrayName = this.variableUtil.calVarInConf(content, "loopArrayName");
        String loopCurrentName = this.variableUtil.calVarInConf(content, "loopCurrentName");
        if (StringUtil.isBlank((String)loopCurrentName)) {
            loopCurrentName = "manateeExcelLoopCurrentName";
        }
        ArrayList loopArray = (ArrayList)content.getValue(loopArrayName);
        for (int i = 0; i < loopArray.size(); ++i) {
            LinkedHashMap jsonObject = (LinkedHashMap)loopArray.get(i);
            content.putRequest(loopCurrentName, (Object)jsonObject);
            String sheetName = this.variableUtil.calVarInConf(content, "sheetKey");
            if (StringUtil.isBlank((String)sheetName)) {
                sheetName = "sheet" + i;
            }
            content.setTempConf(conf);
            List value = (List)this.inputUtil.getHandleData(content, null);
            content.removeTempConf();
            WriteExcelBO excelBO = new WriteExcelBO();
            List<Map<String, Object>> orderList = this.initHeadAndOrderColumn(excelBO, conf, value, content);
            Object zipNumObj = this.processConfUtil.getConf(content, "zipNum", (Object)5000);
            Integer zipNum = zipNumObj instanceof String ? Integer.valueOf(Integer.parseInt((String)zipNumObj)) : (Integer)zipNumObj;
            Integer total = new BigDecimal(orderList.size()).divide(new BigDecimal(zipNum <= 0 ? Integer.MAX_VALUE : zipNum), 0, 0).intValue();
            if (total > 0) {
                for (int j = 1; j < total + 1; ++j) {
                    int start = (j - 1) * zipNum;
                    int end = j * zipNum;
                    if (end > orderList.size() || zipNum <= 0) {
                        end = orderList.size();
                    }
                    WriteExcelBO newExcelBO = this.getNewWriteExcelBO(excelBO);
                    List<Map<String, Object>> subValue = orderList.subList(start, end);
                    newExcelBO.setList(subValue);
                    newExcelBO.setSheetName(sheetName);
                    if (total == 1) {
                        this.addExcelBO(content, newExcelBO, fileMap, 0);
                        continue;
                    }
                    this.addExcelBO(content, newExcelBO, fileMap, j);
                }
                continue;
            }
            excelBO.setList(new ArrayList<Map<String, Object>>());
            excelBO.setSheetName(sheetName);
            this.addExcelBO(content, excelBO, fileMap, 0);
        }
    }

    private void handleASheet(ProcessContent content, JSONObject conf, Map<String, List<WriteExcelBO>> fileMap) throws BizException {
        String sheetNameVar = conf.getString("sheetName");
        content.getStepConf().put("sheetName", (Object)sheetNameVar);
        String sheetName = this.variableUtil.calVarInConf(content, "sheetName");
        content.setTempConf(conf);
        String syntaxType = conf.getString("syntaxTypeDataProcess");
        List value = (List)this.inputUtil.getHandleDataV2(content, null, syntaxType);
        content.removeTempConf();
        WriteExcelBO excelBO = new WriteExcelBO();
        List<Map<String, Object>> orderList = this.initHeadAndOrderColumn(excelBO, conf, value, content);
        Object zipNumObj = this.processConfUtil.getConf(content, "zipNum", (Object)5000);
        Integer zipNum = zipNumObj instanceof String ? Integer.valueOf(Integer.parseInt((String)zipNumObj)) : (Integer)zipNumObj;
        Integer total = new BigDecimal(orderList.size()).divide(new BigDecimal(zipNum <= 0 ? Integer.MAX_VALUE : zipNum), 0, 0).intValue();
        if (total > 0) {
            for (int i = 1; i < total + 1; ++i) {
                int start = (i - 1) * zipNum;
                int end = i * zipNum;
                if (end > orderList.size() || zipNum <= 0) {
                    end = orderList.size();
                }
                WriteExcelBO newExcelBO = this.getNewWriteExcelBO(excelBO);
                List<Map<String, Object>> subValue = orderList.subList(start, end);
                newExcelBO.setList(subValue);
                newExcelBO.setSheetName(sheetName);
                if (total == 1) {
                    this.addExcelBO(content, newExcelBO, fileMap, 0);
                    continue;
                }
                this.addExcelBO(content, newExcelBO, fileMap, i);
            }
        } else {
            excelBO.setList(new ArrayList<Map<String, Object>>());
            excelBO.setSheetName(sheetName);
            this.addExcelBO(content, excelBO, fileMap, 0);
        }
    }

    private WriteExcelBO getNewWriteExcelBO(WriteExcelBO oldObj) {
        WriteExcelBO newExcelBO = new WriteExcelBO();
        newExcelBO.setHead(oldObj.getHead());
        newExcelBO.setHeadStyle(oldObj.getHeadStyle());
        newExcelBO.setTitleStyle(oldObj.getTitleStyle());
        newExcelBO.setTitleName(oldObj.getTitleName());
        newExcelBO.setSummaryInfo(oldObj.getSummaryInfo());
        newExcelBO.setSummaryStyle(oldObj.getSummaryStyle());
        newExcelBO.setColumnWidthStyle(oldObj.getColumnWidthStyle());
        return newExcelBO;
    }

    private List<Map<String, Object>> initHeadAndOrderColumn(WriteExcelBO excelBO, JSONObject conf, List<Map<String, Object>> beanMapList, ProcessContent content) throws BizException {
        ArrayList<Map<String, Object>> orderList = new ArrayList<Map<String, Object>>();
        JSONObject head = conf.getJSONObject("head");
        String titleNameVar = conf.getString("titleName");
        content.getStepConf().put("titleName", (Object)titleNameVar);
        String titleName = this.variableUtil.calVarInConf(content, "titleName");
        excelBO.setTitleName(titleName);
        String summaryInfoVar = conf.getString("summaryInfo");
        content.getStepConf().put("summaryInfo", (Object)summaryInfoVar);
        String summaryInfo = this.variableUtil.calVarInConf(content, "summaryInfo");
        excelBO.setSummaryInfo(summaryInfo);
        ArrayList<Object> headList = new ArrayList<Object>();
        excelBO.setHead(headList);
        ArrayList<String> headKeyList = new ArrayList<String>();
        for (Map.Entry aMap : head.entrySet()) {
            headKeyList.add((String)aMap.getKey());
            headList.add(aMap.getValue());
        }
        Long manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
        if (manateeProcessVersion == null || manateeProcessVersion < 403020100L) {
            this.getStile(excelBO, conf, head);
        } else {
            this.getStileV2(excelBO, conf, head);
        }
        if (beanMapList == null || beanMapList.size() == 0) {
            return orderList;
        }
        JSONArray check = conf.getJSONArray("check");
        if (check == null || check.size() <= 0) {
            for (Map<String, Object> beanMap : beanMapList) {
                Map<String, Object> orderMap = this.orderColumn(headKeyList, beanMap);
                orderList.add(orderMap);
            }
            return orderList;
        }
        CheckContent checkContent = this.initCheckContent(content);
        HashSet<String> paramNamesSet = new HashSet<String>();
        for (Object o : check) {
            String[] checkNameArr;
            JSONObject checkJson = new JSONObject((Map)o);
            String checkName = checkJson.getString("checkName");
            if (StringUtil.isBlank((String)checkName)) continue;
            for (String paramName : checkNameArr = checkName.split(StrSplit.D)) {
                paramNamesSet.add(paramName);
            }
        }
        for (Map<String, Object> beanMap : beanMapList) {
            Map<String, Object> orderMap = this.orderColumn(headKeyList, beanMap);
            this.getWriteCellData(orderMap, checkContent, paramNamesSet, check, beanMap);
            orderList.add(orderMap);
        }
        return orderList;
    }

    private void getWriteCellData(Map<String, Object> orderMap, CheckContent checkContent, Set<String> paramNamesSet, JSONArray check, Map<String, Object> beanMap) {
        WriteCellStyle normalWriteCellStyle = new WriteCellStyle();
        normalWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        normalWriteCellStyle.setBorderTop(BorderStyle.THIN);
        normalWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        normalWriteCellStyle.setBorderRight(BorderStyle.THIN);
        normalWriteCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        normalWriteCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        normalWriteCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        normalWriteCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        WriteCellStyle errorWriteCellStyle = new WriteCellStyle();
        errorWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        errorWriteCellStyle.setBorderTop(BorderStyle.THIN);
        errorWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        errorWriteCellStyle.setBorderRight(BorderStyle.THIN);
        errorWriteCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        errorWriteCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        errorWriteCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        errorWriteCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        errorWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        errorWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.YELLOW1.getIndex()));
        for (Map.Entry<String, Object> stringObjectEntry : orderMap.entrySet()) {
            WriteCellData writeCellData = new WriteCellData();
            Object value = stringObjectEntry.getValue();
            writeCellData = value instanceof Boolean ? new WriteCellData((Boolean)value) : (value instanceof LocalDateTime ? new WriteCellData((LocalDateTime)value) : (value instanceof BigDecimal ? new WriteCellData((BigDecimal)value) : (value == null ? new WriteCellData(" ") : new WriteCellData(value.toString()))));
            this.initCheckContent((ProcessContent)checkContent);
            HashMap<String, Object> paramsKeyValue = new HashMap<String, Object>();
            for (String paramName : paramNamesSet) {
                if (!StringUtil.isNotBlank((String)paramName) || !paramName.equals(stringObjectEntry.getKey())) continue;
                paramsKeyValue.put(paramName, stringObjectEntry.getValue());
            }
            if (paramsKeyValue.size() > 0) {
                checkContent.getTemp().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                checkContent.setParamsKeyValue(paramsKeyValue);
                this.paramCheckProcess.paramCheck(checkContent, check, null);
                checkContent.getTemp().remove(stringObjectEntry.getKey());
            }
            if (checkContent.isSuccess() || paramsKeyValue.size() <= 0) {
                writeCellData.setWriteCellStyle(normalWriteCellStyle);
            } else {
                writeCellData.setWriteCellStyle(errorWriteCellStyle);
            }
            stringObjectEntry.setValue(writeCellData);
        }
    }

    private CheckContent initCheckContent(ProcessContent content) {
        if (content instanceof CheckContent && content != null) {
            CheckContent checkContent = (CheckContent)content;
            checkContent.setParams(null);
            checkContent.setParamsKeyValue(null);
            return checkContent;
        }
        CheckContent checkContent = new CheckContent();
        checkContent.setRequest(content.getRequest());
        checkContent.setResponse(content.getResponse());
        checkContent.setTemp(content.getTemp());
        return checkContent;
    }

    private void getStile(WriteExcelBO excelBO, JSONObject conf, JSONObject head) throws BizException {
        String styleConfiguration = conf.getString("styleConfiguration");
        if (StringUtil.isBlank((String)styleConfiguration)) {
            return;
        }
        String[] styleArr = styleConfiguration.split(StrSplit.FH);
        JSONObject headStyle = new JSONObject();
        JSONObject titleStyle = new JSONObject();
        JSONObject summaryStyle = new JSONObject();
        for (String style : styleArr) {
            String styleWithOutSpace;
            String[] configAndValue;
            String config;
            String[] configArr;
            if (StringUtil.isBlank((String)style) || (configArr = (config = (configAndValue = (styleWithOutSpace = style.replaceAll(StrSplit.KG, StrSplit.N).replaceAll("\\n", StrSplit.N)).split(StrSplit.DH))[0]).split(StrSplit.PA)).length < 3) continue;
            this.extracted(headStyle, configAndValue, configArr, "head", head);
            this.extracted(titleStyle, configAndValue, configArr, "title", null);
            this.extracted(summaryStyle, configAndValue, configArr, "summary", null);
        }
        excelBO.setHeadStyle(headStyle);
        excelBO.setTitleStyle(titleStyle);
        excelBO.setSummaryStyle(summaryStyle);
    }

    private void getStileV2(WriteExcelBO excelBO, JSONObject conf, JSONObject head) throws BizException {
        String styleConfiguration = conf.getString("styleConfiguration");
        if (StringUtil.isBlank((String)styleConfiguration)) {
            return;
        }
        ProcessContent contentTemp = new ProcessContent();
        Step step = new Step();
        contentTemp.setStep(step);
        JSONObject tempConf = new JSONObject();
        tempConf.put("styleConfiguration", (Object)styleConfiguration);
        contentTemp.getStep().setTempConf(tempConf);
        JSONObject styleJson = (JSONObject)this.inputUtil.handleData(contentTemp, "styleConfiguration", null);
        excelBO.setHeadStyle(styleJson.getJSONObject("head"));
        excelBO.setTitleStyle(styleJson.getJSONObject("title"));
        excelBO.setSummaryStyle(styleJson.getJSONObject("summary"));
        if (styleJson.getJSONObject("column") != null) {
            excelBO.setColumnWidthStyle(styleJson.getJSONObject("column").getJSONObject("width"));
        }
    }

    private boolean extracted(JSONObject style, String[] configAndValue, String[] configArr, String prefix, JSONObject head) {
        if (prefix.equals(configArr[0])) {
            String value;
            JSONObject fildeConf;
            String styleKey = configArr[1];
            if (head != null && head.getString(styleKey) != null) {
                styleKey = head.getString(styleKey);
            }
            if ((fildeConf = style.getJSONObject(styleKey)) == null) {
                fildeConf = new JSONObject();
            }
            if (StringUtil.isBlank((String)(value = configAndValue[1]))) {
                return true;
            }
            if (value.startsWith("\"")) {
                value = value.replaceAll("\"", "");
            }
            fildeConf.put(configArr[2], (Object)value);
            style.put(styleKey, (Object)fildeConf);
        }
        return false;
    }

    private void writeExcels(Map<String, List<WriteExcelBO>> fileMap, String fileExtension, String fileWatermark, String filePassword, JSONObject excelConf) throws BizException {
        for (Map.Entry<String, List<WriteExcelBO>> aMap : fileMap.entrySet()) {
            String filePath;
            File file1;
            String fileName = aMap.getKey();
            StringBuilder sb = new StringBuilder(GlobalConf.TEMP_DIRECTORY).append(fileName);
            String file = sb.toString();
            if (excelConf != null) {
                excelConf.put("fileName", (Object)aMap.getKey());
            }
            if (fileName.contains("/") && !(file1 = new File(filePath = file.substring(0, file.lastIndexOf("/")))).exists()) {
                file1.mkdirs();
            }
            ExceWriteUtil.writeExcelWithStyle(file, aMap.getValue(), fileExtension, fileWatermark, filePassword, excelConf, this.cacheRamUtil);
        }
    }

    private List<String> getFileList(Map<String, List<WriteExcelBO>> fileMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, List<WriteExcelBO>> aMap : fileMap.entrySet()) {
            list.add(aMap.getKey());
        }
        return list;
    }

    private Map<String, Object> orderColumn(List<String> headKeyList, Map<String, Object> data) {
        LinkedHashMap<String, Object> orderMap = new LinkedHashMap<String, Object>();
        for (String string : headKeyList) {
            Object dataValue = data.get(string);
            orderMap.put(string, dataValue);
        }
        if (data.size() == 0) {
            return orderMap;
        }
        for (Map.Entry entry : data.entrySet()) {
            Object aData = orderMap.get(entry.getKey());
            if (aData != null) continue;
            orderMap.put((String)entry.getKey(), entry.getValue());
        }
        return orderMap;
    }

    private void addExcelBO(ProcessContent content, WriteExcelBO excelBO, Map<String, List<WriteExcelBO>> fileMap, Integer index) {
        String file = this.getFileName(content, index);
        excelBO.setFile(file);
        List<WriteExcelBO> list = fileMap.get(file);
        if (list == null) {
            list = new ArrayList<WriteExcelBO>();
            fileMap.put(file, list);
        }
        list.add(excelBO);
    }

    private String getFileName(ProcessContent content, Integer index) {
        String fileExtension = (String)content.getTempContent("fileExtension");
        if (StringUtils.isBlank((CharSequence)fileExtension)) {
            fileExtension = ".xls";
        }
        String name = this.getName(content);
        if (index <= 0) {
            String fileName = name + fileExtension;
            return fileName;
        }
        String fileName = name + "_" + index + fileExtension;
        return fileName;
    }

    private String getName(ProcessContent content) {
        String fileName = (String)content.getTempContent("fileName");
        if (StringUtil.isNotBlank((String)fileName)) {
            return fileName;
        }
        Long userId = content.getUserId();
        String name = "excel_write";
        if (userId != null) {
            name = userId + "";
        }
        return name;
    }

    private String zip(ProcessContent content, List<String> fileList) {
        if (!this.needZip(content, fileList)) {
            return null;
        }
        String name = this.getName(content);
        String zipFileName = "zip_" + name + ".zip";
        StringBuilder sb = new StringBuilder(GlobalConf.TEMP_DIRECTORY).append(zipFileName);
        String zipFile = sb.toString();
        try {
            ZipUtil.zip(fileList, (String)zipFile);
            FileUtil.deleteFiles(fileList);
            return zipFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean needZip(ProcessContent content, List<String> fileList) {
        if (fileList.size() > 1) {
            return true;
        }
        Object zip = this.processConfUtil.getConf(content, "zip", (Object)Boolean.FALSE);
        return !Boolean.FALSE.equals(zip);
    }

    public String getName() {
        return "excelWrite";
    }
}

