/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.swagger.plugin;

import com.fasterxml.classmate.ResolvedType;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.swagger.plugin.SwaggerAddParam;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import springfox.documentation.OperationNameGenerator;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingScannerPlugin;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spring.web.readers.operation.CachingOperationNameGenerator;

@Component
public class SwaggerAddtion
implements ApiListingScannerPlugin {
    public static List<SwaggerAddParam> apiList = new ArrayList<SwaggerAddParam>();

    public static void addApi(SwaggerAddParam addParam) {
        apiList.add(addParam);
    }

    public List<ApiDescription> apply(DocumentationContext documentationContext) {
        return this.trans2ApiDesc(documentationContext, apiList);
    }

    private List<ApiDescription> trans2ApiDesc(DocumentationContext documentationContext, List<SwaggerAddParam> apiList) {
        List<ApiDescription> apiDescriptionList = apiList.stream().filter(api -> api.getGroupName().equals(documentationContext.getGroupName())).map(api -> {
            HttpMethod method = api.getMethod();
            HashSet<String> tags = new HashSet<String>();
            tags.add(api.getTag());
            String modeTypeName = "string";
            if (null != api.getModelType()) {
                try {
                    Class<?> clazz = Class.forName(api.getModelType().getTypeName());
                    ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
                    if (apiModel != null) {
                        modeTypeName = apiModel.value();
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            HashSet<ResponseMessage> responseMessages = new HashSet<ResponseMessage>();
            ResponseMessage responseMessage = new ResponseMessageBuilder().code(200).message("OK").responseModel((ModelReference)new ModelRef(modeTypeName)).headersWithDescription(new HashMap()).build();
            responseMessages.add(responseMessage);
            Operation apiOperation = new OperationBuilder((OperationNameGenerator)new CachingOperationNameGenerator()).method(method).summary(api.getSummary()).deprecated(api.getName()).tags(tags).responseMessages(responseMessages).parameters(api.getRequestParams()).uniqueId(api.getName()).build();
            ApiDescription apiDescription = new ApiDescription(api.getGroupName(), api.getPath(), api.getDescription(), Arrays.asList(apiOperation), Boolean.valueOf(false));
            boolean hasTag = false;
            for (Tag tag : documentationContext.getTags()) {
                if (!tag.getName().equals(api.getTag())) continue;
                hasTag = true;
                break;
            }
            if (!hasTag) {
                documentationContext.getTags().add(new Tag(api.getTag(), "manatee Api"));
            }
            if (HttpMethod.POST.equals((Object)method) && CollUtil.isNotEmpty(api.getRequestParams())) {
                List typeList = api.getRequestParams().stream().map(param -> (ResolvedType)param.getType().orNull()).collect(Collectors.toList());
                documentationContext.getAdditionalModels().addAll(typeList);
            }
            return apiDescription;
        }).collect(Collectors.toList());
        return apiDescriptionList;
    }

    public boolean supports(DocumentationType documentationType) {
        return DocumentationType.SWAGGER_2.equals((Object)documentationType);
    }
}

