/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.swagger.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.process.ProcessDataSource;
import com.manatee.swagger.handle.ISwaggerAddHandle;
import com.manatee.swagger.plugin.SwaggerAddParam;
import com.manatee.swagger.plugin.SwaggerAddtion;
import com.manatee.swagger.plugin.SwaggerDemoResponse;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import springfox.documentation.spring.web.plugins.DocumentationPluginsBootstrapper;

@Component
public class SwaggerManager {
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    Map<String, ISwaggerAddHandle> handlerMap;

    public void initSwagger() {
        try {
            JSONArray allProjectConf = this.processDataSource.getAllProjectConf();
            for (Object projectConf : allProjectConf) {
                JSONObject projectConfJson = JSONObject.parseObject((String)JSON.toJSONString(projectConf));
                Long projectId = projectConfJson.getLong("projectId");
                JSONArray projectAllModule = this.processDataSource.getProjectAllModule(projectId);
                String tag = "\u6d77\u725b\u63a5\u53e3_projectId" + projectId;
                this.addAllModuleToSwagger(tag, projectAllModule);
            }
        }
        catch (BizException e) {
            e.printStackTrace();
        }
    }

    private void addAllModuleToSwagger(String tag, JSONArray moduleArray) {
        for (Object o : moduleArray) {
            JSONObject module = JSONObject.parseObject((String)JSON.toJSONString(o));
            if (!module.getInteger("moduleType").equals(1) || !StringUtil.isNotEmpty((CharSequence)module.getString("processConf"))) continue;
            SwaggerAddParam swaggerAddParam = this.moduleToSwaggerAddParam(tag, module);
            SwaggerAddtion.addApi(swaggerAddParam);
        }
    }

    private SwaggerAddParam moduleToSwaggerAddParam(String tag, JSONObject module) {
        String requestMode = module.getString("requestMode");
        SwaggerAddParam swaggerAddParam = null;
        ISwaggerAddHandle handle = this.handlerMap.get("SwaggerHandle" + requestMode);
        if (handle == null) {
            throw new RuntimeException("\u63a5\u53e3\u6587\u6863\u6682\u4e0d\u652f\u6301\uff1a" + requestMode);
        }
        swaggerAddParam = handle.moduleToSwaggerAddParam(tag, module);
        swaggerAddParam.setModelType((Type)((Object)SwaggerDemoResponse.class));
        return swaggerAddParam;
    }

    private void refreshSwagger(ConfigurableApplicationContext applicationContext) {
        try {
            DocumentationPluginsBootstrapper bootstrapper = (DocumentationPluginsBootstrapper)applicationContext.getBeanFactory().getBean(DocumentationPluginsBootstrapper.class);
            if (bootstrapper.isRunning()) {
                bootstrapper.stop();
            }
            bootstrapper.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

