/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.socket.base;

import java.net.URI;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWebsocketClient
extends WebSocketClient {
    private static Logger LOGGER = LoggerFactory.getLogger(BaseWebsocketClient.class);
    private String clientName;
    private boolean isConnect = false;
    private String sendStr;

    public BaseWebsocketClient(URI serverUri, Map<String, String> httpHeaders, String clientName, String sendStr) {
        super(serverUri, (Draft)new Draft_6455(), httpHeaders, 10);
        this.clientName = clientName;
        this.sendStr = sendStr;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.send(this.sendStr);
    }

    public void onMessage(String s) {
    }

    public void onClose(int i, String s, boolean b) {
        LOGGER.info("------ {} onClose ------{}", (Object)this.clientName, (Object)b);
        this.setConnectState(false);
    }

    public void onError(Exception e) {
        LOGGER.info("------ {} onError ------{}", (Object)this.clientName, (Object)e);
        this.setConnectState(false);
    }

    public void setConnectState(boolean isConnect) {
        this.isConnect = isConnect;
    }

    public boolean getConnectState() {
        return this.isConnect;
    }
}

