/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class InterruptUtil {
    @Resource
    private VariableUtil variableUtil;

    public void initInterruptConf(ProcessContent content, ModuleBO moduleBO) {
        Map interruptMap = moduleBO.getInterrupt();
        if (interruptMap == null) {
            return;
        }
        Integer level = 3;
        String[] exceptionKeys = new String[]{"high", "middle", "low"};
        for (int i = 0; i < exceptionKeys.length; ++i) {
            String key = exceptionKeys[i];
            Integer thisLevel = (Integer)interruptMap.get(key);
            if (thisLevel > level) {
                interruptMap.put(key, level);
                thisLevel = level;
            }
            level = thisLevel;
        }
        content.putTempContent("lowcodeInterrupt", (Object)interruptMap);
    }

    public Integer getInterruptLevelAndRecord(ProcessContent content, Throwable exception) {
        Integer level = this.getInterruptLevel(content, exception);
        if (level == null) {
            return null;
        }
        if (1 == level) {
            this.putInterruptKey(content);
        }
        return level;
    }

    public Integer getInterruptLevel(ProcessContent content, Throwable exception) {
        BizException e2 = null;
        e2 = exception instanceof BizException ? (BizException)exception : new BizException(ResultCode.SYSTEM_ERROR, exception.getMessage(), (Throwable)e2);
        Integer interrupt = e2.getInterrupt();
        if (interrupt != null) {
            return interrupt;
        }
        interrupt = this.getInterruptLevelByConf(content, e2);
        if (interrupt != null) {
            return interrupt;
        }
        return this.getInterruptLevelByDefault(content, e2);
    }

    private Integer getInterruptLevelByDefault(ProcessContent content, BizException e2) {
        String exceptionLevel = this.getExceptionLevel(e2);
        if ("high".equals(exceptionLevel)) {
            return 3;
        }
        if ("low".equals(exceptionLevel)) {
            return 0;
        }
        String outputKey = this.variableUtil.calVarInConf(content, "returnKey");
        if (StringUtil.isBlank((String)outputKey)) {
            return 0;
        }
        return 1;
    }

    private void putInterruptKey(ProcessContent content) {
        String outputKey = this.variableUtil.calVarInConf(content, "returnKey");
        if (outputKey == null) {
            return;
        }
        String valueTo = OutputUtil.getDefaultValueTo(content);
        String interruptKey = valueTo + "interruptKey";
        HashMap<String, String> interruptKeyMap = (HashMap<String, String>)content.getTempContent(interruptKey);
        if (interruptKeyMap == null) {
            interruptKeyMap = new HashMap<String, String>();
            content.putTempContent(interruptKey, interruptKeyMap);
        }
        interruptKeyMap.put(outputKey, "1");
    }

    public boolean interruptDependOn(ProcessContent content) {
        int lastInterrupt = content.getErrorTrace().getInterruptLevel();
        if (lastInterrupt != 1) {
            return false;
        }
        String inputKey = this.variableUtil.calVarInConf(content, "input");
        if (StringUtil.isBlank((String)inputKey) || inputKey.indexOf("{") != -1) {
            return false;
        }
        String valueFrom = InputUtil.getDefaultValueFrom(content);
        String getInterruptKey = this.getInterruptKey(content, valueFrom, inputKey);
        return getInterruptKey != null;
    }

    public void removeDependOnInterrupt(ProcessContent content, String key) {
        String valueTo = OutputUtil.getDefaultValueTo(content);
        String getInterruptKey = this.getInterruptKey(content, valueTo, key);
        if (getInterruptKey == null) {
            return;
        }
        String interruptKey = valueTo + "interruptKey";
        Map interruptKeyMap = (Map)content.getTempContent(interruptKey);
        if (interruptKeyMap == null || interruptKeyMap.size() == 0) {
            return;
        }
        interruptKeyMap.remove(key);
    }

    private String getInterruptKey(ProcessContent content, String valueFrom, String inputKey) {
        String interruptKey = valueFrom + "interruptKey";
        Map interruptKeyMap = (Map)content.getTempContent(interruptKey);
        if (interruptKeyMap == null || interruptKeyMap.size() == 0) {
            return null;
        }
        return (String)interruptKeyMap.get(inputKey);
    }

    private Integer getInterruptLevelByConf(ProcessContent content, BizException e2) {
        Map interruptMap = (Map)content.getTempContent("lowcodeInterrupt");
        if (interruptMap == null) {
            return null;
        }
        String level = this.getExceptionLevel(e2);
        return (Integer)interruptMap.get(level);
    }

    private Integer getInterrupt(BizException exception) {
        exception.getInterrupt();
        ResultCode resultCode = exception.getResultCode();
        if (resultCode == null) {
            return null;
        }
        return resultCode.getInterrupt();
    }

    private String getExceptionLevel(BizException e2) {
        if (e2.equal(ResultCode.SYSTEM_ERROR) || e2.equal(ResultCode.CONF_ERROR)) {
            return "high";
        }
        if (e2.equal(ResultCode.BIZ_ERROR) || e2.equal(ResultCode.PARAM_IS_ERROR)) {
            return "middle";
        }
        return "low";
    }
}

