/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.change;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DoubleFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(DoubleFun.class);
    private String name = "double";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return 0.0;
        }
        Object obj = content.getParameter(0);
        try {
            return Double.valueOf(obj + "");
        }
        catch (Throwable e2) {
            log.error("[DoubleFun.doFunction]_exception", e2);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u8f6cdouble\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

