/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.io.watch;

import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.io.watch.WatchAction;
import com.manatee.common.util.tool.core.io.watch.WatchException;
import com.manatee.common.util.tool.core.io.watch.WatchKind;
import com.manatee.common.util.tool.core.io.watch.Watcher;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class WatchServer
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchService watchService;
    protected WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    protected boolean isClosed;
    private final Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();

    public void init() throws WatchException {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new WatchException(e);
        }
        this.isClosed = false;
    }

    public void setModifiers(WatchEvent.Modifier[] modifiers) {
        this.modifiers = modifiers;
    }

    public void registerPath(Path path, int maxDepth) {
        block3: {
            WatchEvent.Kind<?>[] kinds = ArrayUtil.defaultIfEmpty(this.events, WatchKind.ALL);
            try {
                WatchKey key = ArrayUtil.isEmpty(this.modifiers) ? path.register(this.watchService, kinds) : path.register(this.watchService, kinds, this.modifiers);
                this.watchKeyPathMap.put(key, path);
                if (maxDepth > 1) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            WatchServer.this.registerPath(dir, 0);
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                }
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block3;
                throw new WatchException(e);
            }
        }
    }

    public void watch(WatchAction action, Filter<WatchEvent<?>> watchFilter) {
        WatchKey wk;
        try {
            wk = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            this.close();
            return;
        }
        Path currentPath = this.watchKeyPathMap.get(wk);
        for (WatchEvent<?> event : wk.pollEvents()) {
            if (null != watchFilter && !watchFilter.accept(event)) continue;
            action.doAction(event, currentPath);
        }
        wk.reset();
    }

    public void watch(Watcher watcher, Filter<WatchEvent<?>> watchFilter) {
        this.watch((WatchEvent<?> event, Path currentPath) -> {
            WatchEvent.Kind kind = event.kind();
            if (kind == WatchKind.CREATE.getValue()) {
                watcher.onCreate(event, currentPath);
            } else if (kind == WatchKind.MODIFY.getValue()) {
                watcher.onModify(event, currentPath);
            } else if (kind == WatchKind.DELETE.getValue()) {
                watcher.onDelete(event, currentPath);
            } else if (kind == WatchKind.OVERFLOW.getValue()) {
                watcher.onOverflow(event, currentPath);
            }
        }, watchFilter);
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.close(this.watchService);
    }
}

