/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryTaskProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        List list;
        String userId = this.variableUtil.calVarInConf(content, "userId");
        String processInstanceIds = this.variableUtil.calVarInConf(content, "processInstanceIds");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (StrUtil.isNotBlank((CharSequence)processInstanceIds)) {
            String[] processInstanceIdsArr = processInstanceIds.split(",");
            taskQuery.processInstanceIdIn(processInstanceIdsArr);
        }
        if ((list = taskQuery.list()) != null) {
            ArrayList<Task> addSignerTasks = new ArrayList<Task>();
            HashSet<String> taskIds = new HashSet<String>();
            for (Task task : list) {
                if (!StringUtils.isNotBlank((CharSequence)task.getParentTaskId())) continue;
                addSignerTasks.add(task);
                taskIds.add(task.getParentTaskId());
            }
            for (int i = 0; i < list.size(); ++i) {
                Task task;
                task = (Task)list.get(i);
                String parentTaskId = task.getId();
                if (taskIds.contains(parentTaskId)) {
                    list.remove(i);
                    --i;
                    continue;
                }
                if (!StrUtil.isNotBlank((CharSequence)userId) || StrUtil.equals((CharSequence)task.getAssignee(), (CharSequence)userId)) continue;
                list.remove(i);
                --i;
            }
        }
        String jsonString = JSONUtil.toJsonStr((Object)list);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryTask";
    }
}

