/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.template;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StrUtils;
import com.manatee.common.util.tool.core.bean.BeanUtil;
import com.manatee.common.util.tool.core.text.CharSequenceUtil;
import com.manatee.lowcode.generation.domain.GenerationProcessContentBuilder;
import com.manatee.lowcode.generation.template.base.BaseTemplateImpl;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessUtil;
import com.manatee.process.domain.Step;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaseProcessTemplate
extends BaseTemplateImpl {
    private Logger LOGGER = LoggerFactory.getLogger(BaseProcessTemplate.class);
    private static String stepConfJsonPath;
    @Resource
    private ProcessUtil processUtil;

    @Override
    public String getName() {
        return "baseProcessTemplate";
    }

    @Override
    public void bulid(GenerationProcessContentBuilder content, Step step) throws BizException {
        IProcess process = this.processUtil.getProcess(step.getName());
        if (process == null) {
            this.LOGGER.error("\u9700\u8981\u5f15\u5165\u5bf9\u5e94\u7684\u7ec4\u4ef6\u5305:{}", (Object)step.getName());
            return;
        }
        String name = this.getRelBean(process.getClass().getCanonicalName());
        String className = this.getRelBean(process.getClass().getSimpleName());
        String beanName = CharSequenceUtil.lowerFirst((CharSequence)this.getRelBean(className));
        content.addImportSet(name);
        content.addResourceSet(className + " " + beanName);
        String funName = BaseProcessTemplate.privateParamsFun(content, step);
        content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("// ").append(step.getTitle()).append("\n");
        content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("get").append(funName).append("(content);").append("\n");
        content.getCurrentCodeBuilder().append(content.getIndentationStr()).append(beanName + ".process(content); \n");
    }

    private String getRelBean(String beanName) {
        if (StrUtils.isBlank((String)beanName)) {
            return null;
        }
        return CharSequenceUtil.subBefore((CharSequence)beanName, (CharSequence)"$", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String privateParamsFun(GenerationProcessContentBuilder content, Step step) {
        StringBuilder funName = new StringBuilder(CharSequenceUtil.upperFirst((CharSequence)step.getName()));
        funName.append("Params");
        Set<String> privateFunNames = content.getPrivateFunName();
        int i = 1;
        while (privateFunNames.contains(funName.toString())) {
            funName.append(i);
            ++i;
        }
        privateFunNames.add(funName.toString());
        content.getImportSet().add("com.alibaba.fastjson.JSONObject");
        content.getImportSet().add("com.manatee.process.domain.Step");
        StringWriter out = new StringWriter();
        Map map = BeanUtil.beanToMap((Object)step);
        LinkedList<StringBuilder> funNameList = new LinkedList<StringBuilder>();
        funNameList.add(funName);
        map.put("funName", funNameList);
        JsonStringEncoder instance = JsonStringEncoder.getInstance();
        char[] chars = instance.quoteAsString(step.getConf().toJSONString());
        String charsstr = new String(chars);
        HashMap<String, Object> stepMap = new HashMap<String, Object>(1);
        stepMap.put("stepConfStr", charsstr);
        content.generateByTemplate(stepMap, "stepConfJson.json.ftl", stepConfJsonPath + "/" + step.getId() + ".json");
        map.put("confJsonPath", "confJson/" + step.getId() + ".json");
        try {
            GenerationProcessContentBuilder.generateToStream(map, "pricateFun.ftl", out);
            String funCode = out.toString();
            content.getPrivateFuns().add(funCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return funName.toString();
    }

    public static String getStepConfJsonPath() {
        return stepConfJsonPath;
    }

    public void setStepConfJsonPath(String stepConfJsonPath) {
        BaseProcessTemplate.stepConfJsonPath = stepConfJsonPath;
    }
}

