/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.fileDelete;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LocalFileDeleteProcess
implements IProcess {
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        File file;
        String deleteType = content.getStepConf().getString("deleteType");
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        String foldPath = this.variableUtil.calVarInConf(content, "foldPath");
        String returnKey = this.variableUtil.calVarInConf(content, "returnKey");
        if ("filePath".equals(deleteType) && filePath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u6587\u4ef6\u8def\u5f84");
        }
        if ("foldPath".equals(deleteType) && foldPath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u76ee\u5f55\u8def\u5f84");
        }
        int deleteNum = 0;
        if ("filePath".equals(deleteType)) {
            File file2 = new File(filePath);
            if (file2.isFile()) {
                file2.delete();
                deleteNum = 1;
            }
        } else if ("foldPath".equals(deleteType) && (file = new File(foldPath)).isDirectory()) {
            deleteNum = this.removeAll(file);
        }
        this.outputUtil.setDefaultReturnKey(content, returnKey);
        this.outputUtil.putData(content, (Object)deleteNum);
    }

    private int removeAll(File file) {
        int deleteNum = 0;
        if (!file.exists()) {
            return 0;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                deleteNum += this.removeAll(f);
            }
        }
        file.delete();
        return ++deleteNum;
    }

    public String getName() {
        return "localFileDelete";
    }
}

