/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.abstractModule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.process.execute.DebugUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AbstractModuleProcess
implements IProcess {
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private ProcessChain processChain;
    @Resource
    private ProcessConfUtil processConfUtil;
    private static Set<String> STEP_NAME = new HashSet<String>(){
        {
            this.add("abstractUnit");
            this.add("ifProcess");
            this.add("loopProcess");
            this.add("switchCaseProcess");
            this.add("tryCatchProcess");
            this.add("cacheProcess");
            this.add("retryProcess");
            this.add("breakProcess");
            this.add("asyProcess");
        }
    };

    public void process(ProcessContent processContent) throws BizException {
        Long parentProjectId = processContent.getStepConf().getLong("parentProjectId");
        String parentCode = processContent.getStepConf().getString("parentCode");
        this.processConfUtil.checkConf(processContent, new String[]{"config"});
        JSONObject conf = processContent.getStepConf();
        JSONArray logicArray = conf.getJSONArray("config");
        HashMap<String, List<Step>> aLogicSteps = new HashMap<String, List<Step>>();
        for (int i = 0; i < logicArray.size(); ++i) {
            JSONObject aLogic = logicArray.getJSONObject(i);
            String parentNodeId = aLogic.getString("parentNodeId");
            List steps = ProcessDataSource.formatSteps((JSONObject)aLogic);
            if (DebugUtil.isDebug((ProcessContent)processContent) && steps != null && steps.size() > 0) {
                Step step = (Step)steps.get(0);
                step.getConf().put("abstractUnitNodeId", (Object)aLogic.getString("id"));
            }
            aLogicSteps.put(parentNodeId, steps);
        }
        ModuleBO data = this.processDataSource.getData(parentCode, parentProjectId);
        if (data == null) {
            throw new BizException(ResultCode.CONF_ERROR, "process_not_found, code: \u3010" + parentCode + "\u3011");
        }
        int setpOfset = 0;
        ArrayList needRunSteps = new ArrayList();
        List parentSteps = data.getSteps();
        for (int i = 0; i < parentSteps.size(); ++i) {
            Step parentStep = (Step)parentSteps.get(i);
            String parentStepId = parentStep.getId();
            this.extractedConfigs(aLogicSteps, setpOfset, parentStep);
            this.extractedStep(aLogicSteps, setpOfset, parentStep);
            String parentStepName = parentStep.getName();
            if (!"abstractUnit".equals(parentStepName)) {
                if (i < parentSteps.size() - 1) continue;
                needRunSteps.addAll(parentSteps.subList(setpOfset, parentSteps.size()));
                continue;
            }
            List realSteps = (List)aLogicSteps.get(parentStepId);
            if (setpOfset < parentSteps.size()) {
                needRunSteps.addAll(parentSteps.subList(setpOfset, i));
            }
            if (realSteps != null) {
                needRunSteps.addAll(realSteps);
            }
            setpOfset = i + 1;
        }
        this.processChain.executeSteps(processContent, needRunSteps);
        processContent.removeRequest("manatee_return_flag");
        processContent.removeRequest("manatee_break_flag");
    }

    private void extractedConfigs(Map<String, List<Step>> aLogicSteps, int setpOfset, Step parentStep) {
        JSONArray stepConfigs = parentStep.getConf().getJSONArray("config");
        if (stepConfigs == null) {
            return;
        }
        for (Object stepConfigObj : stepConfigs) {
            JSONObject stepConfigJson = (JSONObject)stepConfigObj;
            this.extracted(aLogicSteps, setpOfset, stepConfigJson);
        }
    }

    private void extractedStep(Map<String, List<Step>> aLogicSteps, int setpOfset, Step parentStep) {
        JSONObject stepConfigs = parentStep.getConf();
        if (stepConfigs == null) {
            return;
        }
        this.extracted(aLogicSteps, setpOfset, stepConfigs);
    }

    private void extracted(Map<String, List<Step>> aLogicSteps, int setpOfset, JSONObject stepConfigs) {
        JSONArray subSteps = stepConfigs.getJSONArray("steps");
        if (subSteps == null) {
            return;
        }
        int stepsSonOfset = 0;
        JSONArray needRunStepsSon = new JSONArray();
        for (int j = 0; j < subSteps.size(); ++j) {
            JSONObject subStep = (JSONObject)subSteps.get(j);
            this.extractedConfigs(aLogicSteps, 0, subStep);
            this.extracted(aLogicSteps, 0, subStep);
            if (j >= subSteps.size() - 1 && !subStep.getString("name").equals("abstractUnit")) {
                needRunStepsSon.addAll((Collection)subSteps.subList(stepsSonOfset, subSteps.size()));
                continue;
            }
            if (!subStep.getString("name").equals("abstractUnit")) continue;
            List<Step> realSteps = aLogicSteps.get(subStep.getString("id"));
            if (setpOfset < subSteps.size()) {
                needRunStepsSon.addAll((Collection)subSteps.subList(stepsSonOfset, j));
            }
            if (realSteps != null) {
                for (Step realStep : realSteps) {
                    needRunStepsSon.add((Object)realStep.getConf());
                }
            }
            if (j >= subSteps.size() - 1 && needRunStepsSon.size() <= 0) {
                needRunStepsSon.addAll((Collection)subSteps);
            }
            stepsSonOfset = j + 1;
        }
        stepConfigs.put("steps", (Object)needRunStepsSon);
    }

    private void extractedConfigs(Map<String, List<Step>> aLogicSteps, int setpOfset, JSONObject stepConfigs) {
        JSONArray subSteps = stepConfigs.getJSONArray("config");
        if (subSteps == null) {
            return;
        }
        for (Object stepConfigObj : subSteps) {
            JSONObject stepConfigJson = (JSONObject)stepConfigObj;
            this.extracted(aLogicSteps, setpOfset, stepConfigJson);
        }
    }

    public String getName() {
        return "abstractModule";
    }
}

