/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds;

import com.manatee.common.exception.BizException;
import com.manatee.lowcodedb.newdb.ds.GlobalDSFactory;
import com.manatee.lowcodedb.newdb.ds.bee.BeeDSFactory;
import com.manatee.lowcodedb.newdb.ds.c3p0.C3p0DSFactory;
import com.manatee.lowcodedb.newdb.ds.dbcp.DbcpDSFactory;
import com.manatee.lowcodedb.newdb.ds.druid.DruidDSFactory;
import com.manatee.lowcodedb.newdb.ds.hikari.HikariDSFactory;
import com.manatee.lowcodedb.newdb.ds.pooled.PooledDSFactory;
import com.manatee.lowcodedb.newdb.ds.tomcat.TomcatDSFactory;
import java.io.Closeable;
import java.io.Serializable;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DSFactory
implements Closeable,
Serializable {
    private static final long serialVersionUID = -8789780234095234765L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DSFactory.class);
    public static final String[] KEY_CONN_PROPS = new String[]{"remarks", "useInformationSchema"};
    public static final String[] KEY_ALIAS_URL = new String[]{"url", "jdbcUrl"};
    public static final String[] KEY_ALIAS_DRIVER = new String[]{"driver", "driverClassName"};
    public static final String[] KEY_ALIAS_USER = new String[]{"user", "username"};
    public static final String[] KEY_ALIAS_PASSWORD = new String[]{"pass", "password"};
    protected final String dataSourceName;

    public DSFactory(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public DataSource getDataSource() throws BizException {
        return this.getDataSource("");
    }

    public abstract DataSource getDataSource(String var1) throws BizException;

    @Override
    public void close() {
        this.close("");
    }

    public abstract void close(String var1);

    public abstract void destroy();

    public static DataSource get() throws BizException {
        return DSFactory.get(null);
    }

    public static DataSource get(String group) throws BizException {
        return GlobalDSFactory.get().getDataSource(group);
    }

    public static DSFactory create(HashMap<String, String> setting) {
        DSFactory dsFactory = DSFactory.doCreate(setting);
        LOGGER.debug("Use [{}] DataSource As Default", (Object)dsFactory.dataSourceName);
        return dsFactory;
    }

    private static DSFactory doCreate(HashMap<String, String> setting) {
        try {
            return new HikariDSFactory(setting);
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            try {
                return new DruidDSFactory(setting);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError2) {
                try {
                    return new TomcatDSFactory(setting);
                }
                catch (NoClassDefFoundError | NoSuchMethodError linkageError3) {
                    try {
                        return new BeeDSFactory(setting);
                    }
                    catch (NoClassDefFoundError | NoSuchMethodError linkageError4) {
                        try {
                            return new DbcpDSFactory(setting);
                        }
                        catch (NoClassDefFoundError | NoSuchMethodError linkageError5) {
                            try {
                                return new C3p0DSFactory(setting);
                            }
                            catch (NoClassDefFoundError | NoSuchMethodError linkageError6) {
                                return new PooledDSFactory(setting);
                            }
                        }
                    }
                }
            }
        }
    }
}

